/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.helper.remote.CommandExecutionResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiskSpaceCheckResult
implements CommandExecutionResult {
    public static final int SUCCESS = 0;
    public static final int FAILED = 1;
    public static final int CONNECTION_FAILED = 2;
    private static final long serialVersionUID = -4197377659884637349L;
    private int status;
    private Map<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>();
    private String resultMessage = "Success";

    public DiskSpaceCheckResult(int status, String hostName, Map<String, List<String>> homeResultMap) {
        this.result.put(hostName, homeResultMap);
    }

    public Map<String, Map<String, List<String>>> getResult() {
        return this.result;
    }

    public int getResultStatus() {
        return this.status;
    }

    public void setResultStatus(int status) {
        this.status = status;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiskSpaceCheckResult content: \n");
        sb.append("status: ");
        sb.append(this.status);
        sb.append("\n");
        sb.append("resultMessage: ");
        sb.append(this.resultMessage);
        sb.append("\n");
        if (this.result != null) {
            for (String host : this.result.keySet()) {
                Map<String, List<String>> content = this.result.get(host);
                if (content == null) continue;
                sb.append("For host ");
                sb.append(host);
                sb.append(" following are home status for space:\n");
                for (String home : content.keySet()) {
                    sb.append("home: " + home);
                    sb.append("\n");
                    List<String> homeStatus = content.get(home);
                    sb.append("status: " + homeStatus.get(0) + "\n");
                    sb.append("message: " + homeStatus.get(1) + "\n");
                }
            }
        }
        return sb.toString();
    }
}

