/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DiskSpaceCheckHelper;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DiskSpaceCheckRequestParam;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DiskSpaceCheckResult;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class CloneHomeSpaceValidator
implements IValidator {
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
    Logger logger = Logger.getLogger(CloneHomeSpaceValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        block15: {
            String patchLoc = (String)params.get(ValidationParamKey.PATCH_LOC.ordinal());
            if (patchLoc == null) {
                this.addSuccessResult();
                return this.multipleValidationResult;
            }
            HashMap<String, Map<String, String>> hostWithHomes = new HashMap<String, Map<String, String>>();
            long patchSize = this.getDirectorySize(new File(patchLoc));
            this.logger.info("Size of patch directory " + patchSize);
            Map cloneHomeMap = (Map)params.get(ValidationParamKey.CLONE_HOME_MAP.ordinal());
            Set<String> originalHomeSet = cloneHomeMap.keySet();
            ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
            String homePath = this.getHomePathToBeUsed(originalHomeSet, configGraph);
            this.logger.info("Home path to be used: " + homePath);
            List<Host> hostList = configGraph.getTargets(Host.class);
            for (Host host : hostList) {
                String hostName = host.getHostName();
                this.logger.info("hostName: " + hostName);
                if (hostName.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) {
                    hostWithHomes.put(hostName, cloneHomeMap);
                    continue;
                }
                HashMap remoteCloneMap = new HashMap();
                for (String home : originalHomeSet) {
                    if (!this.isCheckRequiredForHome(home, configGraph, hostName)) continue;
                    remoteCloneMap.put(home, cloneHomeMap.get(home));
                }
                if (remoteCloneMap.isEmpty()) continue;
                hostWithHomes.put(hostName, remoteCloneMap);
            }
            DiskSpaceCheckRequestParam request = new DiskSpaceCheckRequestParam(patchSize, hostWithHomes, this.getSerializedObjLoc(homePath, "checkSpaceResponse.obj"));
            if (OsysUtility.isRootAccess()) {
                String homeOwner = FileUtility.checkFileOwner((File)new File(homePath, "oraInst.loc"));
                String filePath = this.getSerializedObjLoc(homePath, "checkSpaceReq.obj");
                DBPatchingUtil.createNewFile(filePath, homeOwner, null);
                try {
                    FileUtility.persistDataObj((String)filePath, (Object)request, (boolean)false);
                }
                catch (IOException e) {
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.DISK_SPACE_CHECK_FAILED, e.getMessage()));
                    return this.multipleValidationResult;
                }
                ArrayList<String> cmdArr = new ArrayList<String>();
                cmdArr.add(OsysUtility.getSuCommand());
                cmdArr.add(homeOwner);
                String os = System.getProperty("os.name").toLowerCase();
                if (!os.startsWith("sunos")) {
                    cmdArr.add("-m");
                }
                cmdArr.add("-c");
                cmdArr.add(this.getNonRootScriptCommand(this.getSerializedObjLoc(homePath, "checkSpaceReq.obj"), homePath));
                OsysUtility.CommandExecutionResult executionResult = OsysUtility.executeCmd(cmdArr);
                File requestFile = new File(filePath);
                if (requestFile.exists()) {
                    requestFile.delete();
                }
                try {
                    if (executionResult.isOk()) {
                        DiskSpaceCheckResult result = (DiskSpaceCheckResult)FileUtility.deserializeDataObj((String)request.getResponseObjectLocation());
                        this.handleResult(result);
                        break block15;
                    }
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.DISK_SPACE_CHECK_FAILED, executionResult.getErrorMessage()));
                }
                catch (ClassNotFoundException e) {
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.DISK_SPACE_CHECK_FAILED, "Disk space check failed due to " + e.getMessage()));
                }
                catch (IOException e) {
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.DISK_SPACE_CHECK_FAILED, "Disk space check failed due to " + e.getMessage()));
                }
            } else {
                DiskSpaceCheckHelper helper = new DiskSpaceCheckHelper();
                DiskSpaceCheckResult result = helper.checkDiskSpace(request);
                this.handleResult(result);
            }
        }
        if (this.multipleValidationResult.isEmpty()) {
            this.logger.info("Space check successful");
            this.addSuccessResult();
        }
        return this.multipleValidationResult;
    }

    private String getHomePathToBeUsed(Set<String> originalHomeSet, ConfigGraph configGraph) {
        Iterator<String> homeIterator = originalHomeSet.iterator();
        String homePath = null;
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        List<Host> hostList = configGraph.getTargets(Host.class);
        HashSet tmpList = new HashSet();
        while (homeIterator.hasNext()) {
            String tmpPath = homeIterator.next();
            for (OracleHome home : oracleHomes) {
                if (!new File(tmpPath).equals(new File(home.getPath()))) continue;
                tmpList.addAll(home.getHosts());
            }
            if (!tmpList.containsAll(hostList)) continue;
            homePath = tmpPath;
            break;
        }
        if (homePath == null) {
            this.logger.info("Home is not located in all host");
            homePath = originalHomeSet.iterator().next();
        }
        return homePath;
    }

    private void handleResult(DiskSpaceCheckResult result) {
        if (result.getResultStatus() == 0) {
            for (String hostName : result.getResult().keySet()) {
                Map<String, List<String>> homeSpaceStatus = result.getResult().get(hostName);
                for (String cloneHome : homeSpaceStatus.keySet()) {
                    List<String> cloneHomeStatus = homeSpaceStatus.get(cloneHome);
                    if (Boolean.valueOf(cloneHomeStatus.get(0)).booleanValue()) continue;
                    this.logger.info("Space check failed: " + cloneHomeStatus.get(1));
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INSUFFICIENT_DISK_SPACE_FOR_OOP, "Insufficient disk space for creating a clone home on local node, please refer to logs for more details."));
                }
            }
        } else {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.DISK_SPACE_CHECK_FAILED, "Disk space check failed due to " + result.getResultMessage()));
        }
    }

    private String getNonRootScriptCommand(String requestObjLoc, String homePath) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(homePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(homePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl ");
        remoteCommand.append(" -OBJECTLOC=").append(requestObjLoc);
        remoteCommand.append(" -JVM_HANDLER=com/oracle/glcm/patch/auto/db/product/validation/validators/DiskSpaceCheckHelper ");
        return remoteCommand.toString();
    }

    private boolean isCheckRequiredForHome(String path, ConfigGraph graph, String hostName) {
        boolean isCheckRequiredForHome = true;
        boolean homeFound = false;
        List<OracleHome> ohList = graph.getTargets(OracleHome.class);
        block0: for (OracleHome oh : ohList) {
            if (!DBPatchingHelper.compareFilePath(path, oh.getPath())) continue;
            List hostList = oh.getHosts();
            for (Host host : hostList) {
                this.logger.info("host: " + host.getHostName());
                if (!hostName.equals(host.getHostName())) continue;
                homeFound = true;
                if (!oh.getIsShared()) continue block0;
                this.logger.info("Home is shared so skipping validation on remote");
                isCheckRequiredForHome = false;
                continue block0;
            }
        }
        if (!homeFound) {
            isCheckRequiredForHome = false;
        }
        this.logger.info("Check required for home " + path + ":" + isCheckRequiredForHome);
        return isCheckRequiredForHome;
    }

    private String getSerializedObjLoc(String homePath, String fileName) {
        String objLoc = HelperUtility.detectOraBaseHome((String)homePath) + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + fileName;
        return objLoc;
    }

    private void addSuccessResult() {
        this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Success"));
    }

    private long getDirectorySize(File path) {
        long size = 0L;
        for (File currentFile : Arrays.asList(path.listFiles())) {
            if (currentFile.isFile()) {
                size += currentFile.length();
                continue;
            }
            size += this.getDirectorySize(currentFile);
        }
        return size;
    }
}

