/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardProperty;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CatalogDataValidator
implements IValidator {
    private Logger logger = Logger.getLogger(CatalogDataValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        String message;
        Object value;
        String key;
        this.logger.log(Level.FINE, "Invoking catalog home validation to check whether supplied catalog details are correct or not.");
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        boolean isOgg = PatchActionUtil.isOgg(systemInst);
        ArrayList databases = new ArrayList();
        databases.addAll(systemInst.getTargetsOfType(SIDatabase.class));
        databases.addAll(systemInst.getTargetsOfType(RACDatabase.class));
        HashMap shardEmptyMap = new HashMap();
        HashMap shardImproperMap = new HashMap();
        boolean hasPrimary = false;
        for (AbstractBaseTarget database : databases) {
            HashMap<String, String> invalidValuesMap = new HashMap<String, String>();
            ArrayList<String> emptyValuesList = new ArrayList<String>();
            ShardProperty shardProp = null;
            String dbname = "";
            if (database instanceof SIDatabase) {
                SIDatabase sidb = (SIDatabase)database;
                shardProp = sidb.getShardProperty();
            } else if (database instanceof RACDatabase) {
                RACDatabase racdb = (RACDatabase)database;
                shardProp = racdb.getShardProperty();
            }
            if (shardProp != null) {
                dbname = shardProp.getShardName();
                if (StringUtil.isNullOrEmpty((String)shardProp.getShardHost())) {
                    emptyValuesList.add("DB_HOST");
                }
                if (!StringUtil.isNullOrEmpty((String)shardProp.getShardVersion()) && (shardProp.getShardVersion().startsWith("12.1") || shardProp.getShardVersion().startsWith("11"))) {
                    String message2 = BundleUtils.getMessage(CatalogDataValidator.class, "SKIP_LOWER_VERSION_SHARDS", shardProp.getShardName(), shardProp.getShardVersion());
                    Reporting.report((String)message2);
                }
                if (StringUtil.isNullOrEmpty((String)shardProp.getOraceHomePath())) {
                    emptyValuesList.add("ORACLE_HOME");
                }
                if (!isOgg && shardProp.getDrsetNumber() == null) {
                    emptyValuesList.add("DG_BROKER_ID");
                }
                if (StringUtil.isNullOrEmpty((String)shardProp.getStatus())) {
                    emptyValuesList.add("STATUS");
                } else if (!shardProp.getStatus().equalsIgnoreCase("GSM_SET_UP") && !shardProp.getStatus().equalsIgnoreCase("REPLICATON_CONFIGURED")) {
                    invalidValuesMap.put("STATUS", shardProp.getStatus());
                }
                if (StringUtil.isNullOrEmpty((String)shardProp.getDbType())) {
                    emptyValuesList.add("RAC_TYPE");
                } else if (shardProp.getDbType().equalsIgnoreCase("UNKNOWN")) {
                    invalidValuesMap.put("RAC_TYPE", shardProp.getDbType());
                }
                if (!isOgg && shardProp.getIsPrimary().equalsIgnoreCase("Y")) {
                    hasPrimary = true;
                }
            }
            if (dbname != null && !emptyValuesList.isEmpty()) {
                shardEmptyMap.put(dbname, emptyValuesList);
            }
            if (dbname == null || invalidValuesMap.isEmpty()) continue;
            shardImproperMap.put(dbname, invalidValuesMap);
        }
        this.checkHomeSharing(systemInst, multipleValidationResult);
        if (!isOgg) {
            this.validateDataguard(systemInst, multipleValidationResult);
        }
        if (!isOgg && !hasPrimary) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_PRIMARY_SHARD, null));
        }
        boolean isError = false;
        if (shardEmptyMap != null && !shardEmptyMap.isEmpty()) {
            isError = true;
            for (Map.Entry entry : shardEmptyMap.entrySet()) {
                key = (String)entry.getKey();
                value = (List)entry.getValue();
                message = BundleUtils.getMessage(CatalogDataValidator.class, "EMPTY_CATALOG_DATA", key.toString(), value.toString());
                Reporting.report((String)message);
            }
        }
        if (shardImproperMap != null && !shardImproperMap.isEmpty()) {
            isError = true;
            for (Map.Entry entry : shardImproperMap.entrySet()) {
                key = (String)entry.getKey();
                value = (HashMap)entry.getValue();
                message = BundleUtils.getMessage(CatalogDataValidator.class, "IMPROPER_CATALOG_DATA", key.toString(), ((AbstractMap)value).toString());
                Reporting.report((String)message);
            }
        }
        if (isError) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.IMPROPER_CATALOG_DATA, null));
        } else {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        }
        return multipleValidationResult;
    }

    private void checkHomeSharing(SystemInstance systemInst, MultipleValidationResult multipleValidationResult) {
        ArrayList<String> hosts;
        String dbname;
        boolean valid = true;
        HashMap<String, String> hostHomeMap = new HashMap<String, String>();
        for (SIDatabase sidb : systemInst.getTargetsOfType(SIDatabase.class)) {
            dbname = sidb.getShardProperty().getShardName();
            hosts = new ArrayList<String>();
            hosts.add(sidb.getHostName());
            if (this.checkHomeSharing(hosts, sidb.getOracleHome(), hostHomeMap, dbname)) continue;
            valid = false;
        }
        for (RACDatabase racDB : systemInst.getTargetsOfType(RACDatabase.class)) {
            dbname = racDB.getShardProperty().getShardName();
            this.logger.log(Level.INFO, "DB Name: " + dbname);
            hosts = new ArrayList();
            for (RACDBInstance dbInst : racDB.getDbInstances()) {
                this.logger.log(Level.INFO, "WALLET DEBUGGING: Checking hostname for " + dbname + " :" + dbInst.getHost().getHostName());
                hosts.add(dbInst.getHost().getHostName());
            }
            if (this.checkHomeSharing(hosts, racDB.getOracleHome(), hostHomeMap, dbname)) continue;
        }
        if (!valid) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.SHARDS_ON_SAME_HOST, null));
        }
    }

    private boolean checkHomeSharing(ArrayList<String> hosts, String home, HashMap<String, String> hostHomeMap, String dbname) {
        boolean valid = true;
        for (String host : hosts) {
            if (hostHomeMap.containsKey(host + "_" + home)) {
                String message = BundleUtils.getMessage(CatalogDataValidator.class, "SHARDS_ON_SAME_HOST", dbname, hostHomeMap.get(host + "_" + home), home, host);
                Reporting.report((String)message);
                valid = false;
                continue;
            }
            hostHomeMap.put(host + "_" + home, dbname);
        }
        return valid;
    }

    private void validateDataguard(SystemInstance systemInst, MultipleValidationResult multipleValidationResult) {
        ArrayList databases = new ArrayList();
        databases.addAll(systemInst.getTargetsOfType(SIDatabase.class));
        databases.addAll(systemInst.getTargetsOfType(RACDatabase.class));
        ArrayList<Integer> drsetList = new ArrayList<Integer>();
        ArrayList<Integer> primaryList = new ArrayList<Integer>();
        for (AbstractBaseTarget database : databases) {
            boolean isPrimary = false;
            int drsetNumber = -1;
            if (database instanceof RACDatabase) {
                RACDatabase racDatabase = (RACDatabase)database;
                isPrimary = racDatabase.getPrimary();
                drsetNumber = racDatabase.getShardProperty().getDrsetNumber();
            } else if (database instanceof SIDatabase) {
                SIDatabase siDatabase = (SIDatabase)database;
                isPrimary = siDatabase.getPrimary();
                drsetNumber = siDatabase.getShardProperty().getDrsetNumber();
            }
            if (!drsetList.contains(drsetNumber)) {
                drsetList.add(drsetNumber);
            }
            if (!isPrimary || primaryList.contains(drsetNumber)) continue;
            primaryList.add(drsetNumber);
        }
        Iterator iterator = drsetList.iterator();
        while (iterator.hasNext()) {
            int drsetNum = (Integer)iterator.next();
            if (primaryList.contains(drsetNum)) continue;
            String message = BundleUtils.getMessage(CatalogDataValidator.class, "NO_PRIMARY_SHARD_IN_DG", drsetNum);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_PRIMARY_SHARD_IN_DG, drsetNum));
        }
    }
}

