/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.RACOneVersionValidator;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSRACsConfigValidator
implements IValidator {
    Logger logger = Logger.getLogger(CRSRACsConfigValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Invoking rule to ensure that if the RAC object exists, it has instances running out of it and the version, home and host details set.");
        CRSObjectValidator crsObjectValidator = new CRSObjectValidator();
        crsObjectValidator.setClazz(RACOneVersionValidator.class);
        MultipleValidationResult multipleValidationResult = crsObjectValidator.validate(params);
        if (this.getFailureResult(multipleValidationResult)) {
            return multipleValidationResult;
        }
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        CRSCluster crs = (CRSCluster)systemInst.getTop();
        List racs = crs.getDbRAC();
        String message = null;
        String formattedMsg = "";
        ArrayList<BaseClass> missingVersion = new ArrayList<BaseClass>();
        ArrayList<BaseClass> missingHome = new ArrayList<BaseClass>();
        ArrayList<BaseClass> missingHost = new ArrayList<BaseClass>();
        ArrayList<BaseClass> noInstances = new ArrayList<BaseClass>();
        if (racs != null && !racs.isEmpty()) {
            for (RACDatabase rac : racs) {
                if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) {
                    for (RACDBInstance instance : rac.getDbInstances()) {
                        OracleHome home = instance.getRuns_from();
                        if (home == null) {
                            this.logger.log(Level.FINE, "The instance " + instance.getInstanceName() + " doesn't have the runs_from home set.");
                            missingHome.add((BaseClass)instance);
                        } else {
                            this.logger.log(Level.FINE, "The home at " + home.getPath() + " doesn't have the hosts set.");
                            List hosts = home.getHosts();
                            if (hosts == null || hosts.isEmpty()) {
                                missingHost.add((BaseClass)home);
                            }
                        }
                        if (instance.getVersion() != null && instance.getVersion().trim().length() != 0) continue;
                        this.logger.log(Level.FINE, "The instance is missing version information.");
                        missingVersion.add((BaseClass)instance);
                    }
                    continue;
                }
                this.logger.log(Level.FINE, "The RAC Database has no instances associated with it.");
                noInstances.add((BaseClass)rac);
            }
        }
        if (!missingVersion.isEmpty()) {
            message = BundleUtils.getMessage(CRSRACsConfigValidator.class, "MISSING_VERSION", BundleUtils.makeStringOutOfList(missingVersion));
            formattedMsg = ValidationUtil.getFormattedMessage(missingVersion, message);
            this.logger.log(Level.INFO, formattedMsg);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_VERSION, missingVersion));
        }
        if (!missingHome.isEmpty()) {
            message = BundleUtils.getMessage(CRSRACsConfigValidator.class, "RACINSTANCE_MISSING_HOME", BundleUtils.makeStringOutOfList(missingHome));
            formattedMsg = ValidationUtil.getFormattedMessage(missingHome, message);
            this.logger.log(Level.INFO, formattedMsg);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.RACINSTANCE_MISSING_HOME, missingHome));
        }
        if (!missingHost.isEmpty()) {
            message = BundleUtils.getMessage(CRSRACsConfigValidator.class, "RACINSTANCE_MISSING_HOME", BundleUtils.makeStringOutOfList(missingHost));
            formattedMsg = ValidationUtil.getFormattedMessage(missingHost, message);
            this.logger.log(Level.INFO, formattedMsg);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_HOST, missingHost));
        }
        if (!noInstances.isEmpty()) {
            message = BundleUtils.getMessage(CRSRACsConfigValidator.class, "NO_RACINSTANCE", BundleUtils.makeStringOutOfList(noInstances));
            formattedMsg = ValidationUtil.getFormattedMessage(noInstances, message);
            this.logger.log(Level.INFO, formattedMsg);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_RACINSTANCE, noInstances));
        }
        if (!multipleValidationResult.isEmpty()) {
            return multipleValidationResult;
        }
        message = " RAC configuration managed by CRS is valid ";
        this.logger.log(Level.FINE, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean getFailureResult(MultipleValidationResult multipleValidationResult) {
        for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
            if (validationResult.getStatus() != ValidationResult.ValidationStatus.FAILED || validationResult.getFailureReason().equals(DBValidationFailureReason.MISSING_VERSION)) continue;
            return true;
        }
        return false;
    }
}

