/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.sequence;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.common.IListComparator;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.db_crs.HAS;
import java.util.ArrayList;
import java.util.List;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class HostListComparator
implements IListComparator<Host> {
    @Override
    public List<Host> sequence(List<Host> hostList) throws OPatchAutoException {
        ArrayList<Host> sortedHostList = new ArrayList<Host>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        if (hostList != null && !hostList.isEmpty()) {
            ArrayList<Host> hubHostList = new ArrayList<Host>();
            ArrayList<Host> rimHostList = new ArrayList<Host>();
            ArrayList<Host> noRoleHostList = new ArrayList<Host>();
            String localHostName = this.extractHostName(OsysUtility.getHostname());
            Host localHost = null;
            for (int i = 0; i < hostList.size(); ++i) {
                String nodeRole = this.getNodeRoleByHost(hostList.get(i), configGraph);
                if (localHost == null && localHostName.equalsIgnoreCase(hostList.get(i).getHostName())) {
                    localHost = hostList.get(i);
                }
                if (nodeRole != null) {
                    if (this.getNodeRoleByHost(hostList.get(i), configGraph).equalsIgnoreCase("leaf")) {
                        rimHostList.add(hostList.get(i));
                        continue;
                    }
                    hubHostList.add(hostList.get(i));
                    continue;
                }
                noRoleHostList.add(hostList.get(i));
            }
            if (hubHostList != null && !hubHostList.isEmpty()) {
                int localHubNodeIndex = -1;
                if (hubHostList.contains(localHost)) {
                    localHubNodeIndex = hubHostList.indexOf(localHost);
                } else if (rimHostList.contains(localHost) || noRoleHostList.contains(localHost)) {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72036), (Object[])new Object[0]), new Object[0]);
                }
                if (hubHostList.size() > 1) {
                    if (hubHostList.contains(localHost)) {
                        sortedHostList.add(localHost);
                        hubHostList.remove(localHubNodeIndex);
                    }
                    sortedHostList.addAll(hubHostList.subList(0, hubHostList.size() - 1));
                    sortedHostList.addAll(rimHostList);
                    sortedHostList.addAll(noRoleHostList);
                    sortedHostList.add((Host)hubHostList.get(hubHostList.size() - 1));
                } else {
                    sortedHostList.add((Host)hubHostList.get(0));
                    sortedHostList.addAll(rimHostList);
                    sortedHostList.addAll(noRoleHostList);
                }
            } else if (rimHostList != null && !rimHostList.isEmpty()) {
                int localRimNodeIndex = -1;
                if (rimHostList.contains(localHost)) {
                    localRimNodeIndex = rimHostList.indexOf(localHost);
                    sortedHostList.add(localHost);
                    rimHostList.remove(localRimNodeIndex);
                }
                sortedHostList.addAll(rimHostList);
                sortedHostList.addAll(noRoleHostList);
            } else {
                if (noRoleHostList.contains(localHost)) {
                    sortedHostList.add(localHost);
                    noRoleHostList.remove(localHost);
                }
                sortedHostList.addAll(noRoleHostList);
            }
        }
        return sortedHostList;
    }

    private String getNodeRoleByHost(Host host, ConfigGraph configGraph) {
        List<HAS> hasList = configGraph.getConnectedTargets((AbstractBaseTarget)host, HAS.class);
        if (hasList == null || hasList.size() <= 0) {
            return null;
        }
        return hasList.get(0).getNodeRole();
    }

    private String extractHostName(String nodeName) {
        String hostName = nodeName;
        if (nodeName.indexOf(".") != -1) {
            hostName = nodeName.substring(0, nodeName.indexOf("."));
        }
        return hostName;
    }
}

