/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.ApplySessionCookieCreator;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.CommonSessionCookieCreator;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.PrepareSessionCookieCreator;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.RollbackSessionCookieCreator;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.SwitchSessionCookieCreator;
import java.util.List;

public class OOPSessionCookieCreator {
    public OOPSessionCookie create(OOPSessionCookie.OOPOperationType operationType, List<String> requestedHomeList, Credential credential, boolean isRemotePatching, boolean nonrolling) throws OPatchAutoException {
        return this.getCreator(operationType).create(requestedHomeList, credential, isRemotePatching, nonrolling);
    }

    public void merge(OOPSessionCookie.OOPOperationType operationType, OOPSessionCookie cookie, List<String> requestedHomeList, Credential credential, boolean isRemotePatching, boolean nonrolling) throws OPatchAutoException {
        this.getCreator(operationType).merge(cookie, requestedHomeList, credential, isRemotePatching, nonrolling);
    }

    private CommonSessionCookieCreator getCreator(OOPSessionCookie.OOPOperationType operationType) {
        CommonSessionCookieCreator creator = null;
        switch (operationType) {
            case PREPARE: {
                creator = new PrepareSessionCookieCreator();
                break;
            }
            case SWITCH: {
                creator = new SwitchSessionCookieCreator();
                break;
            }
            case APPLY: {
                creator = new ApplySessionCookieCreator();
                break;
            }
            case ROLLBACK: {
                creator = new RollbackSessionCookieCreator();
                break;
            }
        }
        return creator;
    }
}

