/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.helper.remote.exec.model.FileOPeration;
import com.oracle.helper.remote.exec.model.OPeration;
import com.oracle.helper.remote.exec.model.Request;
import com.oracle.helper.remote.exec.model.Response;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class CloneHomePathFinder {
    static final Logger logger = Logger.getLogger(CloneHomePathFinder.class.getName());
    private Map<String, String> originalHomeVsCloneHomeMap = new HashMap<String, String>();
    private Map<String, List<String>> skipOriginalHomeVsCloneHomeMap = new HashMap<String, List<String>>();
    private List<Host> hostList;
    private String homeOwner;

    public Map<String, String> findNFillClonePath(List<String> requestedHomes, Map<String, String> requestedHomesCloneMap, Credential credential) throws OPatchAutoException {
        logger.info("Finding clone home path using silent mode:: " + requestedHomesCloneMap.size());
        logger.info("Requested home size:: " + requestedHomes.size());
        Map<String, String> filteredMap = this.updateMappingEntries(requestedHomesCloneMap);
        Set<String> localHomeSet = this.getLocalHomeSet();
        ArrayList<String> missingRequestedHomes = new ArrayList<String>();
        for (String requestedHome : requestedHomes) {
            if (filteredMap.containsKey(requestedHome = this.removeTrailingFileSeperator(FileUtils.getFile((String)requestedHome).getPath()))) continue;
            missingRequestedHomes.add(requestedHome);
        }
        if (!missingRequestedHomes.isEmpty()) {
            logger.info("Generating default path for homes whose mapping are missing:: " + missingRequestedHomes.toArray());
            this.fillCloneHomePathMap(localHomeSet, missingRequestedHomes);
            logger.info("Missing requested home size:: " + missingRequestedHomes.size());
            this.validate(missingRequestedHomes, true, false, credential);
        }
        this.originalHomeVsCloneHomeMap.putAll(filteredMap);
        this.markEntryForSkipHomeMap(requestedHomes);
        logger.info("Validating home mapping");
        this.validate(requestedHomes, false, true, credential);
        return this.originalHomeVsCloneHomeMap;
    }

    private void markEntryForSkipHomeMap(List<String> requestedHomes) {
        for (String requestedHome : requestedHomes) {
            if (this.skipOriginalHomeVsCloneHomeMap.containsKey(requestedHome = this.removeTrailingFileSeperator(FileUtils.getFile((String)requestedHome).getPath()))) continue;
            this.skipOriginalHomeVsCloneHomeMap.put(requestedHome, new ArrayList());
        }
    }

    private Map<String, String> updateMappingEntries(Map<String, String> mapping) {
        HashMap<String, String> newMapping = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entrySet = mapping.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String requestedHome = this.removeTrailingFileSeperator(FileUtils.getFile((String)entry.getKey()).getPath());
            String cloneHome = this.removeTrailingFileSeperator(FileUtils.getFile((String)entry.getValue()).getPath());
            newMapping.put(requestedHome, cloneHome);
        }
        return newMapping;
    }

    private String removeTrailingFileSeperator(String path) {
        String modifiedPath = path;
        if (path.endsWith(File.separator)) {
            modifiedPath = path.substring(0, path.lastIndexOf(File.separator));
        }
        return modifiedPath;
    }

    public Map<String, String> findNFillClonePath(List<String> requestedHomes, Credential credential) throws OPatchAutoException {
        this.fillCloneHomePathMap(this.getLocalHomeSet(), requestedHomes);
        this.validate(requestedHomes, true, false, credential);
        Scanner scanner = null;
        scanner = new Scanner(System.in);
        for (String currentRequestedHome : requestedHomes) {
            this.validateUserPath(currentRequestedHome, requestedHomes, scanner, credential);
        }
        return this.originalHomeVsCloneHomeMap;
    }

    private Set<String> getLocalHomeSet() {
        List localInfo = OUIDriver.getLocalInfo();
        HashSet<String> localHomeSet = new HashSet<String>();
        for (OracleHome oh : localInfo) {
            localHomeSet.add(oh.getPath());
        }
        return localHomeSet;
    }

    private boolean validate(List<String> requestedHomes, boolean retryAvailable, boolean failOnFirstFailure, Credential credential) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        this.homeOwner = FileUtility.checkFileOwner((File)new File(PatchPlanner.getInstance().getOPlanEnv().getOracleHome(), "oraInst.loc"));
        this.hostList = configGraph.getTargets(Host.class);
        ArrayList<String> cloneHomePaths = new ArrayList<String>(this.originalHomeVsCloneHomeMap.values());
        if (!this.validateClonePath(this.hostList, requestedHomes, cloneHomePaths, retryAvailable, failOnFirstFailure, credential)) {
            throw new OPatchAutoException(Integer.toString(72126), new Object[0]);
        }
        return true;
    }

    private void validateUserPath(String currentRequestedHome, List<String> requestedHomes, Scanner scanner, Credential credential) throws OPatchAutoException {
        String clonePath = this.readCmdLine(currentRequestedHome, scanner);
        if (!StringUtil.isNullOrEmpty((String)clonePath, (boolean)true)) {
            ArrayList<String> clonePaths = new ArrayList<String>();
            clonePaths.add(clonePath);
            if (!this.validateClonePath(this.hostList, requestedHomes, clonePaths, false, false, credential)) {
                if (this.skipOriginalHomeVsCloneHomeMap.containsKey(currentRequestedHome)) {
                    this.skipOriginalHomeVsCloneHomeMap.get(currentRequestedHome).add(clonePath);
                }
                Reporting.report((String)("Specified clone path " + clonePath + " already exists or path is not valid."));
                this.validateUserPath(currentRequestedHome, requestedHomes, scanner, credential);
            } else {
                String reportedHome = this.validateForDuplicates(this.removeTrailingFileSeperator(clonePath));
                if (null != reportedHome) {
                    Reporting.report((String)("Specified clone path " + clonePath + " is already selected for the home " + reportedHome));
                    this.validateUserPath(currentRequestedHome, requestedHomes, scanner, credential);
                } else {
                    this.originalHomeVsCloneHomeMap.put(currentRequestedHome, clonePath);
                    return;
                }
            }
        }
    }

    private String validateForDuplicates(String location) {
        for (String home : this.originalHomeVsCloneHomeMap.keySet()) {
            if (!this.removeTrailingFileSeperator(this.originalHomeVsCloneHomeMap.get(home)).equals(location)) continue;
            return home;
        }
        return null;
    }

    private String readCmdLine(String requestedHome, Scanner scanner) {
        Reporting.report((String)("Please enter clone path [" + this.originalHomeVsCloneHomeMap.get(requestedHome) + " ] :"));
        String clonePath = scanner.nextLine();
        logger.info("User entered clone path :: " + clonePath);
        return clonePath;
    }

    private boolean validateClonePath(List<Host> hostList, List<String> requestedHomes, List<String> cloneHomePaths, boolean retryAvailable, boolean failImmediately, Credential credential) throws OPatchAutoException {
        boolean pathValidOnRemote = true;
        for (Host host : hostList) {
            if (host.getHostName().equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) {
                pathValidOnRemote = this.validateOnLocal(cloneHomePaths) && pathValidOnRemote;
            } else {
                boolean bl = pathValidOnRemote = this.validateOnRemote(host, cloneHomePaths, credential) && pathValidOnRemote;
            }
            if (failImmediately && !pathValidOnRemote) {
                throw new OPatchAutoException(Integer.toString(72126), new Object[]{host.getHostName()});
            }
            if (pathValidOnRemote || cloneHomePaths.size() != 1) continue;
            break;
        }
        if (!pathValidOnRemote && retryAvailable) {
            Set<String> localHomeSet = this.getLocalHomeSet();
            this.fillCloneHomePathMap(localHomeSet, requestedHomes);
            cloneHomePaths = new ArrayList<String>(this.originalHomeVsCloneHomeMap.values());
            if (this.validateClonePath(hostList, requestedHomes, cloneHomePaths, true, false, credential)) {
                return true;
            }
        }
        return pathValidOnRemote;
    }

    private boolean validateOnLocal(List<String> cloneHomePaths) {
        boolean retVal = true;
        for (String fileLoc : cloneHomePaths) {
            if (!new File(fileLoc).exists()) continue;
            retVal = false;
            logger.info("Skip Home List before: " + this.skipOriginalHomeVsCloneHomeMap.get(this.getOriginalHome(fileLoc)));
            List<String> skipList = this.skipOriginalHomeVsCloneHomeMap.get(this.getOriginalHome(fileLoc));
            if (skipList != null) {
                skipList.add(fileLoc);
            }
            logger.info("Skip Home List after : " + this.skipOriginalHomeVsCloneHomeMap.get(this.getOriginalHome(fileLoc)));
        }
        return retVal;
    }

    private void fillCloneHomePathMap(Set<String> localHomeSet, List<String> requestedHomes) throws OPatchAutoException {
        for (String requestedHome : requestedHomes) {
            List<String> skipPaths;
            requestedHome = this.removeTrailingFileSeperator(FileUtils.getFile((String)requestedHome).getPath());
            boolean ignoreSkipList = false;
            if (!this.skipOriginalHomeVsCloneHomeMap.containsKey(requestedHome)) {
                this.skipOriginalHomeVsCloneHomeMap.put(requestedHome, new ArrayList());
                ignoreSkipList = true;
            }
            if ((skipPaths = this.skipOriginalHomeVsCloneHomeMap.get(requestedHome)).isEmpty() && !ignoreSkipList) continue;
            String clonePath = DBPatchingUtil.getSubCloneHomeDir(requestedHome, localHomeSet, new HashSet<String>(skipPaths));
            clonePath = this.removeTrailingFileSeperator(FileUtils.getFile((String)clonePath).getPath());
            logger.info("Clone Home Path.." + clonePath);
            logger.info("Requested Home.." + requestedHome);
            this.originalHomeVsCloneHomeMap.put(requestedHome, clonePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateOnRemote(Host host, List<String> cloneHomePaths, Credential credential) throws OPatchAutoException {
        boolean foundvalidPath;
        block10: {
            foundvalidPath = true;
            boolean checkNeeded = false;
            Request request = new Request(host.getHostName());
            String currentHome = OPatchAutoHelper.getOPatchAutoHome();
            String objLoc = currentHome + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "request_" + host.getHostName() + ".ser";
            String responseObjLoc = currentHome + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "response_" + host.getHostName() + ".ser";
            FileOPeration fopr = null;
            for (String clonePath : cloneHomePaths) {
                if (this.isOriginalHomeSIDBOnly(clonePath, currentHome)) continue;
                fopr = new FileOPeration(clonePath, OPeration.OPerationType.FILEEXIST);
                request.addOperation((OPeration)fopr);
                checkNeeded = true;
            }
            if (!checkNeeded) {
                return true;
            }
            OOPSessionInfoHelper.serializeFile(objLoc, request, this.homeOwner, credential);
            GISystemCall.ExecReturn er = GISystemCall.process(OOPSessionInfoHelper.getRemoteCommand(currentHome, objLoc, responseObjLoc), this.homeOwner, (byte[])null);
            logger.info("Execution result for clone path existence check: " + er.isOK());
            try {
                if (er.isOK()) {
                    try {
                        Response response = (Response)FileUtility.deserializeDataObj((String)responseObjLoc);
                        List ops = response.getRequest().getOperations();
                        for (OPeration op : ops) {
                            boolean tmpContinueNextHost = op.getStatus().equals((Object)OPeration.Status.NOTEXISTS);
                            if (tmpContinueNextHost) continue;
                            String fileLoc = ((FileOPeration)op).getFileLoc();
                            List<String> skipList = this.skipOriginalHomeVsCloneHomeMap.get(this.getOriginalHome(fileLoc));
                            if (skipList != null) {
                                skipList.add(fileLoc);
                            }
                            foundvalidPath = false;
                        }
                        break block10;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new OPatchAutoException((Throwable)e);
                    }
                }
                throw new OPatchAutoException(Integer.toString(72125), new Object[]{host.getHostName()});
            }
            finally {
                new File(responseObjLoc).delete();
                new File(objLoc).delete();
            }
        }
        return foundvalidPath;
    }

    private String getOriginalHome(String clonePath) {
        String originalHomePath = null;
        Set<Map.Entry<String, String>> entrySet = this.originalHomeVsCloneHomeMap.entrySet();
        logger.info("Clone Path Supplied.." + clonePath);
        for (Map.Entry<String, String> entry : entrySet) {
            if (!DBPatchingHelper.compareFilePath(entry.getValue(), clonePath)) continue;
            originalHomePath = entry.getKey();
            break;
        }
        logger.info("Original  Home  .." + originalHomePath);
        return originalHomePath;
    }

    private boolean isOriginalHomeSIDBOnly(String clonePath, String currentHome) {
        String origHome = this.getOriginalHome(clonePath);
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> homeList = configGraph.getTargets(OracleHome.class);
        String localhost = DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost());
        if (StringUtil.isNullOrEmpty((String)origHome, (boolean)true)) {
            origHome = currentHome;
        }
        for (OracleHome oh : homeList) {
            if (!((Host)oh.getHosts().get(0)).getName().equals(localhost) || !oh.getPath().equals(origHome) || !oh.getHomeType().equals("sidb")) continue;
            logger.info("Oracle home " + origHome + " is a sidb-only home." + " Hence, the clone-path will not be validated on the remote hosts.");
            return true;
        }
        return false;
    }
}

