/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.engine;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.CloneCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.engine.ContextPopulator;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cookies.CRSMakeCloneHome;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class CRSContextPopulator
extends ContextPopulator {
    static Logger logger = Logger.getLogger(CRSContextPopulator.class.getName());

    @Override
    public void fixCloneContext(CommandContext context) {
        List<OracleHome> origs = context.getTargets(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        ArrayList<OracleHome> clones = new ArrayList<OracleHome>();
        for (OracleHome orig : origs) {
            CRSMakeCloneHome makeCloneHome = (CRSMakeCloneHome)PatchPlanner.getInstance().getMakeCloneHome();
            List<OracleHome> clonehomes = makeCloneHome.getHomeClone(orig);
            for (OracleHome clone : clonehomes) {
                if ((primaryTarget instanceof RACDatabase || primaryTarget instanceof RACDBInstance || primaryTarget instanceof SIDatabase) && primaryTarget.getProperty(CloneCookie.class) != null) {
                    if (!((CloneCookie)primaryTarget.getProperty(CloneCookie.class)).getClonePath().equals(clone.getPath())) continue;
                    clones.add(clone);
                    continue;
                }
                clones.add(clone);
            }
        }
        if (context.getPrimaryTarget() instanceof OracleHome) {
            List<OracleHome> oracleHomes = PatchPlanner.getInstance().getMakeCloneHome().getHomeClone((OracleHome)context.getPrimaryTarget());
            context.setPrimaryTarget((AbstractBaseTarget)oracleHomes.get(0));
        }
        if (clones != null && clones.size() != 0) {
            context.putTargets(clones);
        }
    }

    private CommandContext populateContextForRACDatabase(ConfigGraph g, RACDatabase racDB, Host host) {
        CommandContext context = new CommandContext();
        ArrayList<RACDBInstance> instances = new ArrayList<RACDBInstance>();
        ArrayList<Host> hosts = new ArrayList<Host>();
        ArrayList<OracleHome> oracleHomeList = new ArrayList<OracleHome>();
        for (RACDBInstance inst : g.getConnectedTargets((AbstractBaseTarget)racDB, RACDBInstance.class)) {
            if (!inst.getHost().getName().equalsIgnoreCase(host.getName())) continue;
            instances.add(inst);
            hosts.add(inst.getHost());
            oracleHomeList.add(this.getRunsFromHome(g, (AbstractBaseTarget)inst));
        }
        context.setPrimaryTarget((AbstractBaseTarget)racDB);
        context.putTargets(instances);
        context.putTargets(hosts);
        context.putTargets(oracleHomeList);
        return context;
    }

    private CommandContext populateContextForRACDBInstance(ConfigGraph g, RACDBInstance dbinst) {
        CommandContext context = new CommandContext();
        context.setPrimaryTarget((AbstractBaseTarget)dbinst);
        context.putTarget((AbstractBaseTarget)dbinst.getDbRAC());
        context.putTarget((AbstractBaseTarget)dbinst.getHost());
        context.putTarget((AbstractBaseTarget)this.getRunsFromHome(g, (AbstractBaseTarget)dbinst));
        return context;
    }

    private CommandContext populateContextForCluster(ConfigGraph g, CRSCluster cluster) {
        ArrayList hosts = new ArrayList(cluster.getNodes());
        Collections.sort(hosts, g.getComparator());
        CommandContext context = new CommandContext();
        context.setPrimaryTarget((AbstractBaseTarget)cluster);
        context.putTargets(hosts);
        ArrayList<HAS> has = new ArrayList<HAS>();
        ArrayList<OracleHome> ohs = new ArrayList<OracleHome>();
        for (HAS inst : g.getConnectedTargets((AbstractBaseTarget)cluster, HAS.class)) {
            has.add(inst);
            ohs.add(this.getRunsFromHome(g, (AbstractBaseTarget)inst));
        }
        if (has.size() > 0) {
            context.putTargets(has);
            context.putTargets(ohs);
        }
        return context;
    }

    @Override
    public CommandContext populateContext(ConfigGraph g, AbstractBaseTarget target, Host host) {
        if (target instanceof RACDatabase) {
            return this.populateContextForRACDatabase(g, (RACDatabase)target, host);
        }
        if (target instanceof RACDBInstance) {
            return this.populateContextForRACDBInstance(g, (RACDBInstance)target);
        }
        if (target instanceof OracleHome) {
            return this.populateContextForOH(g, (OracleHome)target, host);
        }
        if (target instanceof CRSCluster) {
            return this.populateContextForCluster(g, (CRSCluster)target);
        }
        return this.getGenericContext(g, target);
    }
}

