/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sdb;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SystemInstBuilder;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class ShardSystemInstBuilder
extends SDBProductDriver
implements SystemInstBuilder {
    public ShardSystemInstBuilder(List<ShardProperty> shardPropertyList, SystemInstance ti, CredentialManager credentialManager) {
        this.shardPropertyList = shardPropertyList;
        this.ti = ti;
        this.credentialManager = credentialManager;
    }

    @Override
    public SystemInstance createSystemInstance() {
        this.logger.finest("Building Shards");
        ArrayList<Object> shardList = new ArrayList<Object>();
        if (this.shardPropertyList != null) {
            ListIterator shardItr = this.shardPropertyList.listIterator();
            while (shardItr.hasNext()) {
                ShardProperty shardProperty = (ShardProperty)shardItr.next();
                this.logger.fine("DB Type: " + shardProperty.getDbType());
                this.logger.fine("Host Name: " + shardProperty.getShardHost());
                if (shardProperty.getDbType().equalsIgnoreCase("ADMIN_RAC") || shardProperty.getDbType().equalsIgnoreCase("POLICY_RAC")) {
                    RACDatabase racDatabase = this.makeRACDatabase(shardProperty);
                    shardList.add(racDatabase);
                    continue;
                }
                if (!shardProperty.getDbType().equalsIgnoreCase("NON_RAC") && !shardProperty.getDbType().equalsIgnoreCase("SIHA")) continue;
                SIDatabase siDatabase = this.makeSIDatabase(shardProperty);
                shardList.add(siDatabase);
            }
        }
        this.logger.finest("BuildShards completed");
        return this.ti;
    }

    private SIDatabase makeSIDatabase(ShardProperty shardProperty) {
        this.logger.finest("makeSIDatabase start");
        SIDatabase siDatabase = new SIDatabase();
        siDatabase.setName(shardProperty.getShardName());
        siDatabase.setDatabaseName(shardProperty.getShardName());
        siDatabase.setInstanceName(shardProperty.getShardName());
        this.defaultValues((AbstractBaseTarget)siDatabase);
        if (shardProperty.getDrsetNumber() != 0) {
            siDatabase.setPrimary(this.readPrimaryFlag(shardProperty.getIsPrimary()));
            siDatabase.setStandby(!siDatabase.getPrimary());
        } else {
            siDatabase.setPrimary(false);
            siDatabase.setStandby(false);
        }
        siDatabase.setVersion(shardProperty.getShardVersion());
        siDatabase.setOracleHome(shardProperty.getOraceHomePath());
        String owner = this.getHomeOwner(shardProperty.getShardHost(), shardProperty.getOraceHomePath(), false, this.credentialManager, null);
        siDatabase.setOwner(owner.trim());
        Host host = this.createHost(shardProperty.getShardHost());
        this.addHost(host);
        siDatabase.setHost(host);
        siDatabase.setOracleHome(shardProperty.getOraceHomePath());
        siDatabase.setHostName(shardProperty.getShardHost());
        OracleHome oracleHome = this.makeHome(shardProperty, "sidb");
        if (!"rac".equalsIgnoreCase(oracleHome.getHomeType())) {
            oracleHome.setHostName(shardProperty.getShardHost());
            ArrayList<Host> hosts = new ArrayList<Host>();
            hosts.add(host);
            oracleHome.setHosts(hosts);
        }
        oracleHome.getInstalledSWComponents().add(siDatabase);
        siDatabase.setRuns_from(oracleHome);
        siDatabase.setShardProperty(shardProperty);
        this.ti.getEntities().add(shardProperty);
        this.ti.getEntities().add(shardProperty.getRegion());
        this.ti.getEntities().add(siDatabase);
        return siDatabase;
    }

    private RACDatabase makeRACDatabase(ShardProperty shardProperty) {
        this.logger.finest("makeRACDatabase start");
        RACDatabase racDatabase = new RACDatabase();
        racDatabase.setName(shardProperty.getShardName());
        racDatabase.setDatabaseName(shardProperty.getShardName());
        this.defaultValues((AbstractBaseTarget)racDatabase);
        if (shardProperty.getDrsetNumber() != 0) {
            racDatabase.setPrimary(this.readPrimaryFlag(shardProperty.getIsPrimary()));
            racDatabase.setStandby(!racDatabase.getPrimary());
        } else {
            racDatabase.setPrimary(false);
            racDatabase.setStandby(false);
        }
        racDatabase.setVersion(shardProperty.getShardVersion());
        racDatabase.setOracleHome(shardProperty.getOraceHomePath());
        String owner = this.getHomeOwner(shardProperty.getShardHost(), shardProperty.getOraceHomePath(), false, this.credentialManager, null);
        racDatabase.setOwner(owner.trim());
        Host host = this.createHost(shardProperty.getShardHost());
        this.addHost(host);
        racDatabase.setHostName(shardProperty.getShardHost());
        OracleHome oracleHome = this.makeHome(shardProperty, "rac");
        racDatabase.setOracleHome(shardProperty.getOraceHomePath());
        racDatabase.setShardProperty(shardProperty);
        ArrayList<OracleHome> homes = new ArrayList<OracleHome>();
        homes.add(oracleHome);
        host.setOracleHomes(homes);
        this.ti.getEntities().add(shardProperty);
        this.ti.getEntities().add(shardProperty.getRegion());
        this.ti.getEntities().add(racDatabase);
        return racDatabase;
    }

    private OracleHome makeHome(ShardProperty shardProperty, String dbtype) {
        OracleHome oracleHome = new OracleHome();
        oracleHome.setHomeName(shardProperty.getShardName());
        oracleHome.setHostName(shardProperty.getShardHost());
        ArrayList<Host> hosts = new ArrayList<Host>();
        Host host = this.createHost(shardProperty.getShardHost());
        hosts.add(host);
        this.ti.getEntities().add(host);
        oracleHome.setHosts(hosts);
        oracleHome.setPath(shardProperty.getOraceHomePath());
        oracleHome.setHomeType(dbtype);
        oracleHome.setInstalledSWComponents(new ArrayList());
        if (shardProperty.getShardHost() != null) {
            try {
                Credential credential = this.credentialManager.getCredential(shardProperty.getShardHost());
                if (credential == null) {
                    String message = BundleUtils.getMessage(ShardSystemInstBuilder.class, "EMPTY_SHARD_CREDENTIAL", shardProperty.getShardHost());
                    Reporting.report((String)message);
                    throw new ProductDriverException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72075), (Object[])new Object[0]));
                }
            }
            catch (OPatchAutoException e) {
                this.logger.throwing("Detailed Exception while getting the credential for the home : ", e.getMessage(), e);
                throw new ProductDriverException((Throwable)e);
            }
            String owner = this.getHomeOwner(shardProperty.getShardHost(), oracleHome.getPath(), false, this.credentialManager, null);
            oracleHome.setOwner(owner.trim());
        }
        this.addHome(oracleHome);
        return oracleHome;
    }

    private boolean addHost(Host host) {
        boolean found = false;
        for (Host h : this.ti.getTargetsOfType(Host.class)) {
            if (null == h || null == h.getHostName() || !h.getHostName().equalsIgnoreCase(host.getHostName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.ti.getEntities().add(host);
        }
        return !found;
    }

    private boolean addHome(OracleHome oh) {
        boolean found = false;
        for (OracleHome home : this.ti.getTargetsOfType(OracleHome.class)) {
            if (null == home || null == home.getHostName() || !home.getHostName().equalsIgnoreCase(oh.getHostName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.ti.getEntities().add(oh);
        }
        return !found;
    }

    private boolean readPrimaryFlag(String value) {
        this.logger.fine("Flag from catalog: " + value);
        return "Y".equalsIgnoreCase(value);
    }

    private Host createHost(String name) {
        Host host = new Host();
        host.setName(name);
        this.defaultValues((AbstractBaseTarget)host);
        host.setNodeName(name);
        if (name != null) {
            if (Pattern.matches(".*[a-zA-Z]+.*", name)) {
                if (host.getNodeName().indexOf(".") != -1) {
                    host.setDomainName(host.getNodeName().substring(host.getNodeName().indexOf(".") + 1));
                    host.setHostName(host.getNodeName().substring(0, host.getNodeName().indexOf(".")));
                } else {
                    host.setHostName(name);
                    host.setDomainName(null);
                }
            } else {
                host.setHostName(name);
                host.setDomainName(null);
            }
        }
        return host;
    }
}

