/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SystemInstBuilder;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardGroup;
import dbmodel.db_crs.ShardProperty;
import dbmodel.db_crs.ShardedDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ShardGroupSystemInstBuilder
extends SDBProductDriver
implements SystemInstBuilder {
    public ShardGroupSystemInstBuilder(List<ShardProperty> shardPropertyList, SystemInstance ti) {
        this.shardPropertyList = shardPropertyList;
        this.ti = ti;
    }

    @Override
    public SystemInstance createSystemInstance() {
        ShardedDatabase sdb = (ShardedDatabase)this.ti.getTop();
        ArrayList<ShardGroup> shardGroupList = null;
        if (!sdb.getShardingType().equalsIgnoreCase("user-defined")) {
            this.logger.finest("Started building ShardGroups");
            String shardGroupName = "";
            String shardSpaceName = "";
            if (this.shardPropertyList != null) {
                ArrayList databases = new ArrayList();
                databases.addAll(this.ti.getTargetsOfType(SIDatabase.class));
                databases.addAll(this.ti.getTargetsOfType(RACDatabase.class));
                ListIterator shardItr = databases.listIterator();
                while (shardItr.hasNext()) {
                    AbstractBaseTarget shard = (AbstractBaseTarget)shardItr.next();
                    boolean isPresent = false;
                    shardGroupName = "";
                    if (shard instanceof RACDatabase) {
                        RACDatabase racDB = (RACDatabase)shard;
                        shardGroupName = racDB.getShardProperty().getShardGroupName();
                        shardSpaceName = racDB.getShardProperty().getShardSpaceName();
                    } else if (shard instanceof SIDatabase) {
                        SIDatabase siDB = (SIDatabase)shard;
                        shardGroupName = siDB.getShardProperty().getShardGroupName();
                        shardSpaceName = siDB.getShardProperty().getShardSpaceName();
                    }
                    this.logger.fine("shardGroupName : " + shardGroupName);
                    if (StringUtil.isNullOrEmpty((String)shardGroupName)) continue;
                    if (shardGroupList == null) {
                        shardGroupList = new ArrayList<ShardGroup>();
                        ShardGroup shdGrp = this.createNewShardGrpObj(shardGroupName, shardSpaceName, shard);
                        shardGroupList.add(shdGrp);
                    } else {
                        ShardGroup shdGrp;
                        ListIterator shdGrpItr = shardGroupList.listIterator();
                        this.logger.fine("shardGroupList size : " + shardGroupList.size());
                        while (shdGrpItr.hasNext()) {
                            shdGrp = (ShardGroup)shdGrpItr.next();
                            if (null == shdGrp) continue;
                            this.logger.fine("ShardGroupName : " + shdGrp.getShardGroupName());
                            if (null == shdGrp.getShardGroupName() || !shdGrp.getShardGroupName().equalsIgnoreCase(shardGroupName)) continue;
                            shdGrp.getDatabases().add(shard);
                            isPresent = true;
                        }
                        if (!isPresent) {
                            shdGrp = this.createNewShardGrpObj(shardGroupName, shardSpaceName, shard);
                            shardGroupList.add(shdGrp);
                        }
                    }
                    this.logger.fine("shardGroupList size final: " + shardGroupList.size());
                }
            }
            this.logger.finest("Completed building ShardGroups.");
        }
        return this.ti;
    }

    private ShardGroup createNewShardGrpObj(String shardGroupName, String shardSpaceName, AbstractBaseTarget shard) {
        this.logger.finest("Creating new shardgroup object for shardgroup : " + shardGroupName);
        ShardGroup shdGrp = new ShardGroup();
        ArrayList dbList = new ArrayList();
        shdGrp.setDatabases(dbList);
        shdGrp.setShardGroupName(shardGroupName);
        shdGrp.setShardSpaceName(shardSpaceName);
        shdGrp.getDatabases().add(shard);
        this.ti.getEntities().add(shdGrp);
        return shdGrp;
    }
}

