/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sdb;

import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SystemInstBuilder;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.GoldenGateInstance;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardProperty;
import java.util.List;

public class OGGSystemInstBuilder
extends SDBProductDriver
implements SystemInstBuilder {
    public OGGSystemInstBuilder(boolean isOgg, SystemInstance ti, CredentialManager credentialManager) {
        this.isOgg = isOgg;
        this.ti = ti;
        this.credentialManager = credentialManager;
    }

    @Override
    public SystemInstance createSystemInstance() {
        List shardList = this.ti.getTargetsOfType(AbstractBaseTarget.class);
        if (this.isOgg) {
            this.logger.finest("Started building GoldenGate instances");
            if (shardList != null) {
                for (AbstractBaseTarget abt : shardList) {
                    ShardProperty shardProperty = null;
                    GoldenGateInstance goldenGateInstance = new GoldenGateInstance();
                    if (abt instanceof RACDatabase) {
                        RACDatabase racDB = (RACDatabase)abt;
                        shardProperty = racDB.getShardProperty();
                    } else if (abt instanceof SIDatabase) {
                        SIDatabase siDB = (SIDatabase)abt;
                        shardProperty = siDB.getShardProperty();
                    }
                    if (shardProperty == null) continue;
                    goldenGateInstance.setGoldenGateHome(shardProperty.getGoldenGateHome());
                    goldenGateInstance.setVersion(shardProperty.getGoldenGateVersion());
                    goldenGateInstance.setHostName(shardProperty.getShardHost());
                    goldenGateInstance.setOwner(this.getHomeOwner(shardProperty.getShardHost(), shardProperty.getOraceHomePath(), true, this.credentialManager, shardProperty.getGoldenGateHome()));
                    this.ti.getEntities().add(goldenGateInstance);
                    for (BaseClass base : this.ti.getEntities()) {
                        if (base instanceof SIDatabase) {
                            SIDatabase sidb = (SIDatabase)base;
                            sidb.setGoldenGateInstance(goldenGateInstance);
                            continue;
                        }
                        if (!(base instanceof RACDatabase)) continue;
                        RACDatabase racdb = (RACDatabase)base;
                        for (RACDBInstance dbInst : racdb.getDbInstances()) {
                            dbInst.setGoldenGateInstance(goldenGateInstance);
                        }
                    }
                }
            }
            this.logger.finest("Completed building GoldenGateInstances.");
        }
        return this.ti;
    }
}

