/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.engine.ContextPopulator;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.patchmodel.GenericPatch;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class SpfFilePreReqCommand
extends Command {
    private static String DB_LOG = null;

    public SpfFilePreReqCommand(ActionType automationAction) {
        super(automationAction);
        this.automationAction = automationAction;
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> list) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : list) {
            ExecutionStep executionStep;
            CommandContext context = ((ContextPopulator)contextPopulator).populateContext(configGraph, abstractBaseTarget, this.getHost());
            if (this.automationAction.isActsOnClone()) {
                ((ContextPopulator)contextPopulator).fixCloneContext(context);
            }
            if (null == (executionStep = this.getExecutionStep(context))) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    private ExecutionStep getExecutionStep(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        boolean isSQLPatchUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
        ExecutionStep executionStep = null;
        ArrayList<GenericPatch> patches = new ArrayList<GenericPatch>();
        patches.addAll(PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString())));
        patches.addAll(PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString())));
        if (DBCommandUtils.shouldExecuteSqlCommand(primaryTarget, patches, this.automationAction) && isSQLPatchUpgradeMode && (primaryTarget instanceof RACDatabase || primaryTarget instanceof SIDatabase)) {
            executionStep = CommandUtils.getBasicExecutionStep(this.automationAction, context, null);
            if (!this.isDBRunning(primaryTarget, executionStep.getHost())) {
                return executionStep;
            }
            ArrayList<String> cmds = new ArrayList<String>();
            DB_LOG = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "opatchautodb";
            cmds.add("mkdir -p -m 775 " + DB_LOG);
            String spfQueryFile = DB_LOG + File.separator + "spfquery.sql";
            this.makeSpoolCommand(cmds, spfQueryFile);
            String sqlPlusCmd = "cd " + oh.getPath() + "; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + DBCommandUtils.getOracleSID(executionStep, primaryTarget) + " " + "./bin/sqlplus / as sysdba @";
            cmds.add(sqlPlusCmd + spfQueryFile);
            this.makeShellFileContentToSearchContent(cmds, DB_LOG + File.separator + "checkSpfFile");
            cmds.add("chmod +x " + DB_LOG + File.separator + "checkSpfFile");
            cmds.add(DB_LOG + File.separator + "checkSpfFile");
            for (String cmd : cmds) {
                executionStep.getCommand().add(new ExecutionStep.Command(cmd));
            }
        }
        return executionStep;
    }

    private boolean isDBRunning(AbstractBaseTarget database, Host host) {
        boolean isRunning = false;
        if (database instanceof RACDatabase) {
            for (RACDBInstance rdbi : ((RACDatabase)database).getDbInstances()) {
                String isInsRunnning;
                if (!host.getHostName().equals(rdbi.getHost().getHostName()) || null == (isInsRunnning = rdbi.getIsRunning()) || !"yes".equals(isInsRunnning)) continue;
                isRunning = true;
            }
        } else if (database instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)database;
            if (sidb.getAvailability().equals("yes")) {
                isRunning = true;
            } else if (null != sidb.getShardProperty() && null != sidb.getShardProperty().getIsDatabaseUp() && sidb.getShardProperty().getIsDatabaseUp().equalsIgnoreCase("Y")) {
                isRunning = true;
            }
        }
        return isRunning;
    }

    public void makeShellFileContentToSearchContent(List<String> cmd, String fileLoc) {
        cmd.add("echo '#!/bin/bash' > " + fileLoc);
        cmd.add("echo 'CAT_VAL=`cat " + DB_LOG + File.separator + "spf.txt" + "`' >> " + fileLoc);
        cmd.add("echo 'if [ $CAT_VAL = \"SPFILE\" ]; then' >> " + fileLoc);
        cmd.add("echo '   exit 0' >> " + fileLoc);
        cmd.add("echo 'else' >> " + fileLoc);
        cmd.add("echo '  echo ' Datapatch pre check exiting with failure status, as database is not using Spfile.'' >> " + fileLoc);
        cmd.add("echo '   exit 2' >> " + fileLoc);
        cmd.add("echo 'fi' >> " + fileLoc);
    }

    private void makeSpoolCommand(List<String> cmds, String fileLoc) {
        cmds.add("echo 'SET HEADING OFF' > " + fileLoc);
        cmds.add("echo 'SET SERVEROUTPUT OFF' >> " + fileLoc);
        cmds.add("echo 'SPOOL " + DB_LOG + File.separator + "spf.txt' >> " + fileLoc);
        cmds.add("echo \"SELECT DECODE(value, NULL, 'PFILE', 'SPFILE') \\\"Init File Type\\\" FROM sys.v_\\$parameter WHERE name = 'spfile';\" >> " + fileLoc);
        cmds.add("echo 'SPOOL OFF' >> " + fileLoc);
        cmds.add("echo 'quit' >> " + fileLoc);
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph configGraph) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return configGraph.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder<SpfFilePreReqCommand> {
        @Override
        public SpfFilePreReqCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.SPFilePreReqForUpgradeMode.toString())) {
                return null;
            }
            return new SpfFilePreReqCommand(a);
        }
    }
}

