/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleDCLICommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.AllRACOracleHomeLifeCycle;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.CopyDBHome;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.OracleHomeLifecycle;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.OracleHomeRACOneLifecycle;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.PatchRACDBHomeCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.PrePostRACPatchScriptCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.PrePostScriptCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.RACDBShellCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.RACOneDBShellCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.RelinkBinary;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.RelinkBinaryRacOn;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.RelocateDatabaseServices;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.RootCrsCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.SQLPatchUpgradeModeCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.SQLStartupShutdown;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.SpfFilePreReqCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.SqlCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.SqlPatchCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopAndStartDBCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopAndStartRacOneDBShellCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopCrsCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopHasCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopStartDbConsole;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopStartLogShipping;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopStartRedoApply;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopStartSidbOnly;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.SwitchGI;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.UnlockOH;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBCommandFactory
extends CommandFactory {
    private final Logger logger = Logger.getLogger(DBCommandFactory.class.getName());

    public DBCommandFactory() {
        this.constructables.add(new OracleHomeLifecycle.Builder());
        this.constructables.add(new OracleHomeRACOneLifecycle.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new PrePostScriptCommand.Builder()));
        this.constructables.add(new RelinkBinaryRacOn.Builder());
        this.constructables.add(new RelinkBinary.Builder());
        this.constructables.add(new RootCrsCommand.Builder());
        this.constructables.add(new SqlCommand.Builder());
        this.constructables.add(new SqlPatchCommand.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new StopCrsCommand.Builder()));
        this.constructables.add(new StopStartDbConsole.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new UnlockOH.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new SwitchGI.Builder()));
        this.constructables.add(new StopStartLogShipping.Builder());
        this.constructables.add(new StopStartRedoApply.Builder());
        this.constructables.add(new StopHasCommand.Builder());
        this.constructables.add(new RACDBShellCommand.Builder());
        this.constructables.add(new RACOneDBShellCommand.Builder());
        this.constructables.add(new AllRACOracleHomeLifeCycle.Builder());
        this.constructables.add(new PrePostRACPatchScriptCommand.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new PatchRACDBHomeCommand.Builder()));
        this.constructables.add(new StopAndStartRacOneDBShellCommand.Builder());
        this.constructables.add(new SpfFilePreReqCommand.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new CopyDBHome.Builder()));
        this.constructables.add(new StopStartSidbOnly.Builder());
        this.constructables.add(new SQLPatchUpgradeModeCommand.Builder());
        this.constructables.add(new RelocateDatabaseServices.Builder());
        this.constructables.add(new SQLStartupShutdown.Builder());
        this.constructables.add(new StopAndStartDBCommand.Builder());
    }

    @Override
    public boolean includeTargetByVersion(ConfigGraph g, AbstractBaseTarget abt, ExecutionMode exeMode) {
        String version = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isEngSystemPatch = PatchPlanner.getInstance().isEngSysPatch();
        if (version != null) {
            if (isEngSystemPatch) {
                if (abt instanceof CRSCluster) {
                    if (!this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                        this.updateSkipppedTargetMap(CRSCluster.class, abt);
                        return false;
                    }
                } else if (abt instanceof HAS && !this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                    this.updateSkipppedTargetMap(HAS.class, abt);
                    return false;
                }
            }
            if (abt instanceof RACDatabase) {
                if (!this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                    this.updateSkipppedTargetMap(RACDatabase.class, abt);
                    return false;
                }
            } else if (abt instanceof RACDBInstance) {
                if (!this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                    return false;
                }
            } else if (abt instanceof OracleHome) {
                return this.handleOracleHome(g, abt, version);
            }
        }
        return true;
    }

    private boolean handleOracleHome(ConfigGraph g, AbstractBaseTarget abt, String version) {
        AbstractBaseTarget siha;
        boolean includeTarget = true;
        OracleHome oh = (OracleHome)abt;
        if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString().equals(oh.getHomeType())) {
            AbstractBaseTarget crs = g.getRootVertex();
            if (crs != null && !this.formattedVersion(version).equals(this.formattedVersion(crs.getVersion()))) {
                this.updateSkipppedTargetMap(CRSCluster.class, crs);
                includeTarget = false;
            }
        } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString().equals(oh.getHomeType())) {
            List<RACDBInstance> racInst = g.getConnectedTargets((AbstractBaseTarget)oh, RACDBInstance.class);
            if (racInst != null && racInst.size() > 0 && !this.formattedVersion(version).equals(this.formattedVersion(racInst.get(0).getVersion()))) {
                this.updateSkipppedTargetMap(RACDatabase.class, (AbstractBaseTarget)racInst.get(0).getDbRAC());
                includeTarget = false;
            }
        } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString().equals(oh.getHomeType())) {
            List<SIDatabase> sidb = g.getConnectedTargets((AbstractBaseTarget)oh, SIDatabase.class);
            if (sidb != null && sidb.size() != 0 && !this.formattedVersion(version).equals(this.formattedVersion(sidb.get(0).getVersion()))) {
                this.updateSkipppedTargetMap(SIDatabase.class, (AbstractBaseTarget)sidb.get(0));
                includeTarget = false;
            }
        } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.siha.toString().equals(oh.getHomeType()) && (siha = g.getRootVertex()) != null && !this.formattedVersion(version).equals(this.formattedVersion(siha.getVersion()))) {
            this.updateSkipppedTargetMap(HAS.class, siha);
            includeTarget = false;
        }
        return includeTarget;
    }

    private void updateSkipppedTargetMap(Class cls, AbstractBaseTarget abt) {
        if (PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().get(cls) == null) {
            PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().put(cls, new ArrayList());
        }
        if (!PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().get(cls).contains(abt.getName())) {
            PatchPlanner.getInstance().getOPlanEnv().getSkippedTargetMap().get(cls).add(abt.getName());
        }
    }

    private String formattedVersion(String version) {
        return DBPatchingUtil.formattedVersion(version);
    }

    @Override
    protected boolean decideBasedOnWhilePatchingTargetAttribute(Command command, ConfigGraph g, AbstractBaseTarget abt) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(command.getAutomationAction().getWhilePatching());
        if (abt instanceof OracleHome) {
            OracleHome oh = (OracleHome)abt;
            if ((CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.name().equals(oh.getHomeType()) || CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.name().equals(oh.getHomeType())) && HAS.class.isAssignableFrom(type)) {
                this.logger.log(Level.FINER, "DBInstance OH is skipped:" + oh + " so checking if HAS instance is being patched, if so then this DBInstance OH need to be included for this step: " + command.getAutomationAction());
                return this.shouldIncludeDBInstanceCosHASIsPatched(command, g, oh);
            }
            if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.name().equals(oh.getHomeType()) && RACDatabase.class.isAssignableFrom(type)) {
                this.logger.log(Level.FINER, "CRS OH is skipped:" + oh + " so checking if RAC Database is being patched, if so then this CRS OH need to be included for this step: " + command.getAutomationAction());
                return this.shouldIncludeCRSCosRACIsPatched(command, g, oh);
            }
            this.logger.log(Level.FINER, "SkipTargetCookie is set on OracleHome target :" + abt + " and while-patching condition(" + command.getAutomationAction().getWhilePatching() + ") is set for step: " + command.getAutomationAction() + " . Going to check all the targets running from OracleHome: " + oh.getInstalledSWComponents());
            for (AbstractBaseTarget dep : oh.getInstalledSWComponents()) {
                if (!CommandUtils.shouldIncludeTargetCosDependantsNotSkipped(command, g, abt, g.getConnectedTargets(dep, type))) continue;
                return true;
            }
            this.logger.log(Level.FINER, "All the targets running from this OracleHome is being skipped as well. Hence do not generate execution step for this target. ");
            return false;
        }
        if (abt instanceof RACDBInstance && HAS.class.isAssignableFrom(type)) {
            RACDBInstance racDBInst = (RACDBInstance)abt;
            return this.shouldIncludeDBInstanceCosHASIsPatched(command, g, racDBInst.getRuns_from());
        }
        return CommandUtils.shouldIncludeTargetCosDependantsNotSkipped(command, g, abt, g.getConnectedTargets(abt, type));
    }

    private boolean shouldIncludeDBInstanceCosHASIsPatched(Command command, ConfigGraph g, OracleHome racInstanceOracleHome) {
        AbstractBaseTarget root = g.getRootVertex();
        if (root instanceof CRSCluster) {
            CRSCluster cluster = (CRSCluster)root;
            for (Host host : racInstanceOracleHome.getHosts()) {
                for (HAS has : cluster.getHAS()) {
                    if (!has.getHost().equals(host) || CommandUtils.isSkipTargetCookieSet(command, (AbstractBaseTarget)has)) continue;
                    this.logger.log(Level.FINER, "HAS service " + has + " running on host: " + host + "is not being skipped, hence include this step.");
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldIncludeCRSCosRACIsPatched(Command command, ConfigGraph g, OracleHome crsOracleHome) {
        AbstractBaseTarget root = g.getRootVertex();
        if (root instanceof CRSCluster) {
            CRSCluster cluster = (CRSCluster)root;
            for (Host host : crsOracleHome.getHosts()) {
                for (RACDatabase rac : cluster.getDbRAC()) {
                    for (RACDBInstance raci : rac.getDbInstances()) {
                        if (!raci.getHost().equals(host) || CommandUtils.isSkipTargetCookieSet(command, (AbstractBaseTarget)rac)) continue;
                        this.logger.log(Level.FINER, "RAC Database " + rac + " running on host: " + host + "is not being skipped, hence include this step.");
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

