/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product;

import com.oracle.cie.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;

public class OPatchBinaryUtil {
    private static final Logger _log = Logger.getLogger(OPatchBinaryUtil.class.getName());

    public static void main(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        String invPtrLoc = null;
        String homePath = null;
        String action = null;
        for (int i = 0; i < argsList.size(); ++i) {
            if (((String)argsList.get(i)).equalsIgnoreCase("-oh")) {
                homePath = (String)argsList.get(++i);
                continue;
            }
            if (((String)argsList.get(i)).equalsIgnoreCase("-CRS_ACTION")) {
                action = (String)argsList.get(++i);
                continue;
            }
            if (!((String)argsList.get(i)).equalsIgnoreCase("-INVPTRLOC")) continue;
            invPtrLoc = (String)argsList.get(++i);
        }
        if (!StringUtil.isNullOrEmpty(action, (boolean)true) && action.equals("lspatches")) {
            OPatchBinaryUtil.printLSPatches(homePath, invPtrLoc);
        }
    }

    private static void printLSPatches(String homePath, String invPtrLoc) {
        OPatchPatch[] activePatchList = OPatchAutoBinaryUtil.getPatchListFromHome((String)homePath, (String)invPtrLoc);
        String patchIDList = null;
        if (activePatchList.length < 1) {
            System.out.println("No patches applied on the home.");
        } else {
            StringBuilder list = new StringBuilder();
            for (OPatchPatch patch : activePatchList) {
                list.append(patch.getPatchId()).append(",");
            }
            if (list.toString().endsWith(",")) {
                patchIDList = list.toString().substring(0, list.toString().length() - 1);
            }
            System.out.println("PatchList: " + list);
        }
    }
}

