/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb.PseudoSDBTopoBuilder;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationController;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationPhase;
import com.oracle.glcm.patch.auto.topology.Topology;
import dbmodel.SystemInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SDBOptionsAuthorizer {
    private Logger logger = Logger.getLogger(SDBOptionsAuthorizer.class.getName());

    public List<ValidationResult> validateTopology(OPatchAutoOptions options, CredentialManager credentialManager, OPatchAutoCommand command, Topology topology) throws OPatchAutoException {
        List<ValidationResult> failedValidations = new ArrayList<ValidationResult>();
        OPatchAutoOption deployOnlyOption = options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
        Boolean isDeployOnly = Boolean.valueOf(deployOnlyOption.getValue());
        if (isDeployOnly.booleanValue()) {
            return failedValidations;
        }
        OPatchAutoOption sdbOption = options.getOption(DBProductParameterConstants.SDB.getValue());
        OPatchAutoOption sessionOption = options.getOption("session");
        PseudoSDBTopoBuilder pseudoSDBTopoBuilder = new PseudoSDBTopoBuilder();
        Topology tempTopology = pseudoSDBTopoBuilder.createPseudoTopology(options, credentialManager);
        ValidationParam params = new ValidationParam();
        if (null != sdbOption.getValue()) {
            params.set(ValidationParamKey.SDB_OPTION.ordinal(), true);
        }
        if (null != sessionOption.getValue()) {
            params.set(ValidationParamKey.SESSION_ID.ordinal(), sessionOption.getValue());
        }
        if (command.isResumed()) {
            params.set(OPatchAutoCommand.resume.ordinal(), true);
        }
        params.set(ValidationParamKey.PSEUDO_TOPOLOGY.ordinal(), tempTopology);
        params.set(ValidationParamKey.TOPOLOGY.ordinal(), topology);
        params.set(ValidationParamKey.VALIDATION_PHASE.ordinal(), (Object)ValidationPhase.POST_TOPOLOGY);
        params.set(ValidationParamKey.GENERATE_STEP_OPTION.ordinal(), DBPatchingHelper.isGenerateStepCommand(options));
        params.set(ValidationParamKey.SHARD.ordinal(), true);
        params.set(ValidationParamKey.WALLET_LOC.ordinal(), DBPatchingHelper.getWalletLocation(options));
        DBValidationController validationController = new DBValidationController();
        failedValidations = validationController.invoke(params);
        return failedValidations;
    }

    public int validate(OPatchAutoOptions options) {
        ValidationParam params = new ValidationParam();
        String catalogDbHost = null;
        String sid = null;
        String port = null;
        String walletFile = null;
        try {
            OPatchAutoOption deployOnlyOption = options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
            Boolean isDeployOnly = Boolean.valueOf(deployOnlyOption.getValue());
            if (isDeployOnly.booleanValue()) {
                return 0;
            }
            OPatchAutoOption nonrolling = options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue());
            if (Boolean.parseBoolean(nonrolling.getValue())) {
                return 72062;
            }
            OPatchAutoOption logOption = options.getOption(OPatchAutoOptions.LOG_KEY);
            if (!logOption.isUsingDefault()) {
                return 72070;
            }
            OPatchAutoOption sidOption = options.getOption(DBProductParameterConstants.SID.getValue());
            OPatchAutoOption serviceOption = options.getOption(DBProductParameterConstants.SERVICE.getValue());
            OPatchAutoOption portOption = options.getOption(DBProductParameterConstants.PORT.getValue());
            OPatchAutoOption hostOption = options.getOption("host");
            OPatchAutoOption walletOption = options.getOption("wallet");
            OPatchAutoOption sdbOption = options.getOption(DBProductParameterConstants.SDB.getValue());
            OPatchAutoOption dgOption = options.getOption(DBProductParameterConstants.DG.getValue());
            OPatchAutoOption shrdGrpOption = options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue());
            OPatchAutoOption shrdSpcOption = options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue());
            catalogDbHost = hostOption != null && hostOption.getValue() != null ? hostOption.getValue() : OPatchAutoHelper.getOPatchAutoHost();
            if (null != catalogDbHost) {
                params.set(ValidationParamKey.CATALOG_DB_HOST.ordinal(), catalogDbHost);
            }
            if (sidOption != null && sidOption.getValue() != null) {
                sid = sidOption.getValue();
            } else if (serviceOption != null && serviceOption.getValue() != null) {
                params.set(ValidationParamKey.SERVICE.ordinal(), serviceOption.getValue());
            } else {
                sid = System.getenv("ORACLE_SID");
            }
            if (null != sid) {
                params.set(ValidationParamKey.SID.ordinal(), sid);
            }
            if (null != (port = portOption != null && portOption.getValue() != null ? portOption.getValue() : "1521")) {
                params.set(ValidationParamKey.PORT.ordinal(), port);
            }
            if (walletOption != null && walletOption.getValue() != null) {
                walletFile = walletOption.getValue();
            }
            if (null != walletFile) {
                params.set(ValidationParamKey.WALLET_LOC.ordinal(), walletFile);
            }
            if (null != sdbOption.getValue()) {
                params.set(ValidationParamKey.SDB_OPTION.ordinal(), true);
            }
            if (null != dgOption.getValue()) {
                params.set(ValidationParamKey.DG_OPTION.ordinal(), true);
            }
            if (shrdGrpOption != null && null != shrdGrpOption.getValue()) {
                params.set(ValidationParamKey.SHARD_GROUP.ordinal(), true);
            }
            if (shrdSpcOption != null && null != shrdSpcOption.getValue()) {
                params.set(ValidationParamKey.SHARD_SPACE.ordinal(), true);
            }
        }
        catch (OPatchAutoException e) {
            // empty catch block
        }
        params.set(ValidationParamKey.VALIDATION_PHASE.ordinal(), (Object)ValidationPhase.PRODUCT_INITIALISATION);
        DBValidationController validationController = new DBValidationController();
        List<ValidationResult> failedValidations = validationController.invoke(params);
        int status = 0;
        if (!failedValidations.isEmpty()) {
            status = failedValidations.get(0).getFailureReason().getErrorCode();
        }
        if (failedValidations.size() > 1) {
            for (int i = 1; i < failedValidations.size(); ++i) {
                int other_failures = failedValidations.get(i).getFailureReason().getErrorCode();
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(other_failures), (Object[])new Object[0]));
            }
        }
        return status;
    }

    public List<ValidationResult> validate(SystemInstance systemInstance, OPatchAutoOptions options) {
        ValidationParam params = new ValidationParam();
        String walletFile = null;
        List<ValidationResult> failedValidations = new ArrayList<ValidationResult>();
        try {
            OPatchAutoOption deployOnlyOption = options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
            Boolean isDeployOnly = Boolean.valueOf(deployOnlyOption.getValue());
            if (isDeployOnly.booleanValue()) {
                return failedValidations;
            }
            OPatchAutoOption sdbOption = options.getOption(DBProductParameterConstants.SDB.getValue());
            OPatchAutoOption walletOption = options.getOption("wallet");
            OPatchAutoOption dgOption = options.getOption(DBProductParameterConstants.DG.getValue());
            OPatchAutoOption shrdGrpOption = options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue());
            OPatchAutoOption shrdSpcOption = options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue());
            if (null != sdbOption.getValue()) {
                params.set(ValidationParamKey.SDB_OPTION.ordinal(), true);
            } else {
                this.logger.fine("SDB option is null");
            }
            if (walletOption != null && walletOption.getValue() != null) {
                walletFile = walletOption.getValue();
            }
            if (null != dgOption.getValue()) {
                params.set(ValidationParamKey.DG_OPTION.ordinal(), dgOption.getValue());
            }
            if (shrdGrpOption != null && null != shrdGrpOption.getValue()) {
                params.set(ValidationParamKey.SHARD_GROUP.ordinal(), shrdGrpOption.getValue());
            }
            if (shrdSpcOption != null && null != shrdSpcOption.getValue()) {
                params.set(ValidationParamKey.SHARD_SPACE.ordinal(), shrdSpcOption.getValue());
            }
        }
        catch (OPatchAutoException e) {
            this.logger.fine("Exception while fetching opatchauto options : " + e.getMessage());
        }
        params.set(ValidationParamKey.WALLET_LOC.ordinal(), walletFile);
        params.set(ValidationParamKey.SYSTEM_INST.ordinal(), systemInstance);
        params.set(ValidationParamKey.VALIDATION_PHASE.ordinal(), (Object)ValidationPhase.BUILD_TOPOLOGY);
        DBValidationController validationController = new DBValidationController();
        failedValidations = validationController.invoke(params);
        return failedValidations;
    }
}

