/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.SDBTopologyBuilder;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import com.oracle.glcm.patch.auto.topology.Topology;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.DataGuard;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardGroup;
import dbmodel.db_crs.ShardSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class PseudoSDBTopoBuilder {
    private Logger logger = Logger.getLogger(PseudoSDBTopoBuilder.class.getName());
    private SystemInstance systemInstance = null;
    private boolean isOgg = false;
    private String shardingType = null;

    public Topology createPseudoTopology(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        Topology topology = null;
        this.systemInstance = PatchPlanner.getInstance().getSystemInstance();
        this.isOgg = PatchActionUtil.isOgg(this.systemInstance);
        this.shardingType = PatchActionUtil.getShardingType(this.systemInstance);
        ArrayList<AbstractBaseTarget> shardingTargets = new ArrayList<AbstractBaseTarget>();
        boolean isShardedDatabase = Boolean.parseBoolean(options.getOption(DBProductParameterConstants.SDB.getValue()).getValue());
        List<String> shdGrpOptions = options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()) != null ? PatchActionUtil.convertStringToList(options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue()) : null;
        List<String> shdSpcOptions = options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()) != null ? PatchActionUtil.convertStringToList(options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue()) : null;
        List<String> dgOptions = options.getOption(DBProductParameterConstants.DG.getValue()) != null ? PatchActionUtil.convertStringToList(options.getOption(DBProductParameterConstants.DG.getValue()).getValue()) : null;
        shardingTargets.addAll(this.getApplicableDatabases(isShardedDatabase, shdGrpOptions, shdSpcOptions, dgOptions));
        SDBTopologyBuilder sdbTopoBuilder = new SDBTopologyBuilder(null, null);
        sdbTopoBuilder.pseudoInit(isShardedDatabase, this.systemInstance, shdGrpOptions, shdSpcOptions, credentialManager);
        List<com.oracle.glcm.patch.auto.topology.Host> hostList = this.populateTargetHosts(shardingTargets, sdbTopoBuilder);
        if (null != hostList && !hostList.isEmpty()) {
            this.logger.finer("Pseudo hostList : " + hostList.size());
            topology = sdbTopoBuilder.getTopology(hostList);
        }
        this.logger.finer("Pseudo topology used for validations : " + topology);
        return topology;
    }

    private List<AbstractBaseTarget> getApplicableDatabases(boolean isShardedDatabase, List<String> shdGrpOptions, List<String> shdSpcOptions, List<String> dgOptions) {
        ArrayList<AbstractBaseTarget> shardingTargets = new ArrayList<AbstractBaseTarget>();
        if (null != shdGrpOptions) {
            List shdGrps = this.systemInstance.getTargetsOfType(ShardGroup.class);
            for (String shdGrpOption : shdGrpOptions) {
                for (ShardGroup shdGrp : shdGrps) {
                    if (!shdGrpOption.equalsIgnoreCase(shdGrp.getShardGroupName())) continue;
                    shardingTargets.addAll(this.populateTargetsToVerify(shdGrp.getDatabases()));
                }
            }
        }
        if (null != shdSpcOptions) {
            List shdSpcs = this.systemInstance.getTargetsOfType(ShardSpace.class);
            for (String shdSpcOption : shdSpcOptions) {
                for (ShardSpace shdSpc : shdSpcs) {
                    if (!shdSpcOption.equalsIgnoreCase(shdSpc.getShardSpaceName())) continue;
                    shardingTargets.addAll(this.populateTargetsToVerify(shdSpc.getDatabases()));
                }
            }
        }
        if (null != dgOptions) {
            List dataGuards = this.systemInstance.getTargetsOfType(DataGuard.class);
            for (String dgOption : dgOptions) {
                for (DataGuard dataGuard : dataGuards) {
                    if (!dgOption.equalsIgnoreCase(dataGuard.getPrimary().getName())) continue;
                    ArrayList<AbstractBaseTarget> databases = new ArrayList<AbstractBaseTarget>();
                    databases.add(dataGuard.getPrimary());
                    databases.addAll(dataGuard.getStandbyDatabases());
                    shardingTargets.addAll(this.populateTargetsToVerify(databases));
                }
            }
        }
        if (isShardedDatabase && null == shdGrpOptions && null == shdSpcOptions && null == dgOptions) {
            ArrayList<AbstractBaseTarget> databases = new ArrayList<AbstractBaseTarget>();
            databases.addAll(this.systemInstance.getTargetsOfType(SIDatabase.class));
            databases.addAll(this.systemInstance.getTargetsOfType(RACDatabase.class));
            shardingTargets.addAll(this.populateTargetsToVerify(databases));
        }
        return shardingTargets;
    }

    private List<com.oracle.glcm.patch.auto.topology.Host> populateTargetHosts(List<AbstractBaseTarget> shardingTargets, SDBTopologyBuilder sdbTopoBuilder) throws OPatchAutoException {
        ArrayList<com.oracle.glcm.patch.auto.topology.Host> hostList = new ArrayList<com.oracle.glcm.patch.auto.topology.Host>();
        HashMap<String, HostImpl> currentHostMap = new HashMap<String, HostImpl>();
        for (AbstractBaseTarget shardingTarget : shardingTargets) {
            Host hostModel = sdbTopoBuilder.getHost(shardingTarget.getHostName());
            HostImpl host = null;
            if (!currentHostMap.isEmpty() && currentHostMap.keySet().contains(hostModel.getHostName())) {
                host = sdbTopoBuilder.createHost(shardingTarget, (HostImpl)currentHostMap.get(hostModel.getHostName()), true, this.isOgg, this.shardingType);
                continue;
            }
            host = sdbTopoBuilder.createHost(shardingTarget, new HostImpl(), false, this.isOgg, this.shardingType);
            currentHostMap.put(hostModel.getHostName(), host);
            hostList.add((com.oracle.glcm.patch.auto.topology.Host)host);
        }
        return hostList;
    }

    private List<AbstractBaseTarget> populateTargetsToVerify(List<AbstractBaseTarget> databases) {
        ArrayList<AbstractBaseTarget> shardingTargets = new ArrayList<AbstractBaseTarget>();
        List cRSClusters = this.systemInstance.getTargetsOfType(CRSCluster.class);
        List hases = this.systemInstance.getTargetsOfType(HAS.class);
        shardingTargets.addAll(databases);
        for (AbstractBaseTarget abt : databases) {
            String hostname = abt.getHostName();
            if (StringUtil.isNullOrEmpty((String)hostname)) continue;
            for (CRSCluster crs : cRSClusters) {
                if (!hostname.equalsIgnoreCase(crs.getHostName())) continue;
                shardingTargets.add((AbstractBaseTarget)crs);
            }
            for (HAS has : hases) {
                if (!hostname.equalsIgnoreCase(has.getHostName())) continue;
                shardingTargets.add((AbstractBaseTarget)has);
            }
        }
        return shardingTargets;
    }
}

