/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RACFinalizeStartAction
extends DBShutDownStartupAction {
    public RACFinalizeStartAction() {
        super(new Goal[]{StartupPhase.Goal.finalize});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        return !((HomeImpl)patchTarget.getHome()).isGIMRHome();
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        boolean isNoRestartEnable = DBPatchingHelper.isNoRestartEnable(this.getPatchSession().getOptions());
        if (isNoRestartEnable) {
            Reporting.report((String)this.getLocalizedString("StartAction.norestart.pdb.warning", new Object[0]));
            return generatedSteps;
        }
        String primaryPatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        List<ExecutionStep> steps = null;
        if (primaryPatchVersion.startsWith("12.1.0.1")) {
            steps = this.getStartPDBStateCommandExecutionSteps(this.configGraph, patchTarget, "RACDBInstance");
            generatedSteps.addAll(steps);
        }
        if (DBPatchingUtil.isDBVersionEleven(primaryPatchVersion)) {
            steps = this.getStopStartDBConsoleCommandExecutionSteps(this.configGraph, patchTarget, "RACDBInstance", DBShutDownStartupAction.StopStartOperation.STARTUP);
            generatedSteps.addAll(steps);
        }
        if (this.ifServicesNeedsToBeRelocated(patchTarget)) {
            steps = this.getRelocateServicesCommandExecutionSteps(this.configGraph, patchTarget, "RACDBInstance", DBShutDownStartupAction.StopStartOperation.STARTUP);
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        if (!patchActionResult.isFailure() && !this.getPatchSession().isActionSession()) {
            File relocateServiceLocationFile = new File(DBCommandUtils.getSerializationLocationForRelocateServices(patchTarget.getHome().getLocation(), patchTarget.getHost().getHost().toLowerCase()));
            relocateServiceLocationFile.delete();
            this._logger.info("Deleted file " + relocateServiceLocationFile + " from " + patchTarget);
        }
    }
}

