/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.CRSShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;

public class GIShutDownAction
extends CRSShutDownStartupAction {
    public GIShutDownAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown, OfflinePhase.Goal.prepare, OfflinePhase.Goal.finalize_binary_patching});
    }

    @Override
    public List<ExecutionStep> generateCRSSteps(PatchTarget patchTarget) throws OPatchAutoException {
        boolean isRollback = this.getPatchSession().isRollback();
        List<ExecutionStep> generatedSteps = super.generateCRSSteps(patchTarget);
        List<ExecutionStep> steps = null;
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        ArrayList<String> readMeMsg = new ArrayList<String>();
        boolean actsOnClone = false;
        ServiceStatus serviceStatus = ServiceStatus.DOWN;
        if (patchTarget.getHomeClone() != null) {
            actsOnClone = true;
            serviceStatus = ServiceStatus.UP;
            if (isRollback) {
                String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
                generatedSteps.addAll(this.getUpdateBootStrappingInClone(patchTarget, targetHome));
            }
        }
        if (isTwelveVersion) {
            if (isRollback) {
                readMeMsg.add("Rootcrs-Prepatch-Rollback-Title");
                readMeMsg.add("Rootcrs-Prepatch-Rollback-Message");
                if (primarypatchVersion.startsWith("12.1.0.1") || DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "19.0.0.0.0")) {
                    if (primarypatchVersion.startsWith("12.1.0.1")) {
                        actsOnClone = false;
                    }
                    steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnClone, DBCommandParameters.PREPATCH.getValue());
                } else {
                    steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnClone, DBCommandParameters.PREPATCH.getValue(), DBCommandParameters.ROLLBACK.getValue());
                }
            } else {
                readMeMsg.add("Rootcrs-Prepatch-Title");
                readMeMsg.add("Rootcrs-Prepatch-Message");
                steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnClone, DBCommandParameters.PREPATCH.getValue());
            }
            generatedSteps.addAll(steps);
        } else {
            readMeMsg.add("Rootcrs-Unlock-Title");
            readMeMsg.add("Rootcrs-Unlock-Message");
            steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "crs", serviceStatus, readMeMsg, CommandActionType.shell.toString(), false, DBCommandParameters.UNLOCK.getValue());
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }
}

