/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public abstract class PrereqAction
extends DBCommonPatchAction {
    private List<String> analysisSummary = null;

    public PrereqAction(Goal goal) {
        super(goal);
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        if (DBPatchingHelper.isDatabaseHomeTarget(patchTarget)) {
            try {
                if (DBPatchingHelper.skipDeployInitSession(this.getPatchSession().getProductSupportManager().getOptions(), this.getPatchSession().getCurrentGoal())) {
                    isActionRequired = false;
                }
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
        return isActionRequired;
    }

    @Override
    protected ExecutionResult runCommand(PatchTarget patchTarget, ExecutionStep executionStep) throws CommandFailureException {
        ExecutionResult result = null;
        try {
            result = super.runCommand(patchTarget, executionStep);
            this.createSummaryDetails(executionStep, result);
        }
        catch (CommandFailureException e) {
            String command = e.getCommand();
            if (command.indexOf("datapatch") != -1) {
                String session = this.getLocalizedString("analyzed.session.value", new Object[0]);
                Reporting.report((String)this.getLocalizedString("SQLAction.sql.patch.warning", command, session));
                ExecutionResult executionResult = result = new ExecutionResult(new ArrayList<ExecutionResult.CommandExecutionResult>());
                executionResult.getClass();
                result.addCommandResult(new ExecutionResult.CommandExecutionResult(executionResult, ExecutionResult.ExecutionStatus.SUCCESS, e.getMessage(), e.getMessage(), e.getCommand()));
            }
            throw e;
        }
        return result;
    }

    @Override
    protected StringBuilder generateErrorSummary(PatchTarget target, ExecutionStep step, String command, String commandOutPut, String errorMessage) {
        StringBuilder builder = super.generateErrorSummary(target, step, command, commandOutPut, errorMessage);
        builder.append("\n" + this.processCommandFailure(command, step.getAutomationAction().getType(), commandOutPut, errorMessage));
        return builder;
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        PatchActionResult result = super.executeSteps(executionSteps, patchTarget);
        if (this.analysisSummary != null && !this.analysisSummary.isEmpty()) {
            result.setDetails(this.analysisSummary);
        }
        return result;
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        super.postExecute(patchTarget, patchActionResult);
        if (patchActionResult.isFailure()) {
            return;
        }
        DBPatchingSummaryCreator summaryCreator = ((DBProductSupport)this.getPatchSession().getProductSupportManager().getProductSupport("db")).getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
        StringBuilder summary = new StringBuilder();
        if (patchActionResult.getDetailsList() != null && !patchActionResult.getDetailsList().isEmpty() && this.getPatchSession().getPatchTracking() != null) {
            for (String tmp : patchActionResult.getDetailsList()) {
                summary.append(tmp);
            }
            summaryCreator.storePatchingSummary(1, SummaryID.patching_analyze, patchTarget, summary.toString());
        }
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        return new ArrayList<ExecutionStep>();
    }

    protected List<ExecutionStep> getSPFilePreReqCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.SPFilePreReqForUpgradeMode.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "SQL-SPFile-PreReq-For-UpgradeMode-Title");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.PRE_REQ, ServiceStatus.UP);
        Command versionCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, versionCommand);
        return steps;
    }

    protected List<ExecutionStep> getSQLpatchApplyCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, String acts_on) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        HashMap commandDetails = new HashMap();
        ArrayList paramList = new ArrayList();
        String sqlApplyPatchCommandStr = "%OracleHome.path%/OPatch/datapatch";
        commandDetails.put(sqlApplyPatchCommandStr, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "SQL-Step-Analyze-Title");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.PRE_REQ, ServiceStatus.UP);
        Command sqlPatchApplyCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, sqlPatchApplyCommand);
        block0: for (ExecutionStep step : steps) {
            if (!step.getAutomationAction().getType().startsWith("SqlPatch")) continue;
            for (ExecutionStep.Command command : step.getCommand()) {
                String version = DBPatchingHelper.getDBVersion(step.getActsOnTarget());
                if (!this.isCommandContainsDBInformation(command.getValue()) || command.getValue().indexOf("datapatch") == -1 || this.isSQLCommandRequired(patchTarget, step.getRunsOnOracleHome().getPath(), step.getUser().getValue(), command.getValue(), acts_on, version)) continue;
                step.getCommand().clear();
                continue block0;
            }
        }
        return steps;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        return true;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("PrereqAction.start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("PrereqAction.failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("PrereqAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("PrereqAction.success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    private boolean isSQLCommandRequired(PatchTarget target, String homePath, String user, String command, String actOn, String version) {
        boolean isRequired = true;
        String instName = DBPatchingUtil.getInstNameUsingCommand(command);
        boolean isDBUp = true;
        String dbname = "";
        if (actOn.equals("SIDatabase")) {
            dbname = DBPatchingUtil.getSIDBNameFromInstancename(instName, target);
            if (!DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) && !StringUtil.isNullOrEmpty((String)dbname, (boolean)true)) {
                isDBUp = DBPatchingUtil.isDBUpOnSIHA(homePath, dbname, user, target, version);
            }
        } else {
            dbname = DBPatchingUtil.getRACDBNameFromInstancename(instName, target);
            if (!DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) && !StringUtil.isNullOrEmpty((String)dbname, (boolean)true)) {
                isDBUp = DBPatchingUtil.isRACOneDB(dbname) ? DBPatchingUtil.isRACOneDBUp(homePath, dbname, target.getHost().getHost(), user, target, version) : DBPatchingUtil.isDBInstanceUp(homePath, dbname, target.getHost().getHost(), user, target, version);
            }
        }
        try {
            if (DBPatchingHelper.isStandByDatabase(dbname, this.getPatchSession().getOptions(), actOn)) {
                Reporting.report((String)this.addTag(this.getLocalizedString("PrereqAction.command.standby.skipped", dbname)));
                isRequired = false;
            }
        }
        catch (OPatchAutoException e) {
            this._logger.warning("Exception while getting opatchauto options :  " + e.getMessage());
        }
        if (StringUtil.isNullOrEmpty((String)dbname, (boolean)true) && instName != null) {
            this._logger.log(Level.INFO, "Database instance \"" + instName + "\" is not running.");
            isRequired = false;
        }
        if (!isDBUp) {
            this._logger.log(Level.INFO, "Database \"" + dbname + "\" is not running. ");
            isRequired = false;
        }
        return isRequired;
    }

    private boolean isCommandContainsDBInformation(String command) {
        return command.contains("ORACLE_HOME=") && command.contains("ORACLE_SID=");
    }

    private String processCommandFailure(String command, String type, String outputMsg, String errorMsg) {
        StringBuffer errorBuff = new StringBuffer();
        errorBuff.append("\n");
        if (outputMsg != null && outputMsg.indexOf("Log file location") != -1) {
            errorBuff.append(this.getLocalizedString("PatchAction.log.summary", outputMsg.substring(20 + outputMsg.indexOf("Log file location"), 4 + outputMsg.indexOf(".log"))));
        } else if (StringUtil.isNullOrEmpty((String)errorMsg)) {
            errorBuff.append(outputMsg);
        } else {
            errorBuff.append(errorMsg);
        }
        return errorBuff.toString();
    }

    private void createSummaryDetails(ExecutionStep step, ExecutionResult result) {
        if (result != null) {
            for (ExecutionResult.CommandExecutionResult commandStatus : result.getResultList()) {
                ExecutionResult.ExecutionStatus status = commandStatus.getStatus();
                if (!this.getPatchSession().isAnalyze() || status != ExecutionResult.ExecutionStatus.FAILURE || step.getAutomationAction().getType().startsWith("SqlPatch")) continue;
                if (this.analysisSummary == null) {
                    this.analysisSummary = new ArrayList<String>();
                }
                StringBuilder errorDetails = new StringBuilder();
                errorDetails.append(this.getLocalizedString("PrereqAction.command.message", commandStatus.getCommand()));
                errorDetails.append(this.getLocalizedString("PrereqAction.command.failure.summary", new Object[0]));
                errorDetails.append(this.processCommandFailure(commandStatus.getCommand(), step.getAutomationAction().getType(), commandStatus.getMessage(), commandStatus.getErrorMessage()));
                this.analysisSummary.add(errorDetails.toString());
            }
        }
    }
}

