/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.RemoteAnalysisStatusRetriever;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.SystemInstance;
import dbmodel.db_crs.ShardedDatabase;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class PatchActionUtil {
    private static final Logger logger = Logger.getLogger(PatchActionUtil.class.getName());

    public static ExecutionResult.CommandExecutionResult execute(ArrayList<String> cmds, String parentid, PatchTarget patchTarget, boolean reportAnalyzeFailure, CredentialManager credentialManager) {
        ExecutionResult result;
        ProcessBuilder pb = new ProcessBuilder(cmds);
        int retValue = -1;
        StringBuffer errorBuff = new StringBuffer();
        StringBuffer inputBuff = new StringBuffer();
        try {
            Process process = pb.start();
            InputStreamReader reader1 = new InputStreamReader(process.getInputStream());
            BufferedReader br1 = new BufferedReader(reader1);
            String line1 = "";
            StringBuffer buff = null;
            boolean isMsgComplete = false;
            boolean hasTagStarted = false;
            while ((line1 = br1.readLine()) != null) {
                if (line1.contains("<sharding>")) {
                    buff = new StringBuffer();
                    isMsgComplete = false;
                    hasTagStarted = true;
                }
                if (hasTagStarted && !isMsgComplete) {
                    String edited_line = PatchActionUtil.getProcessedSummary(line1, parentid);
                    buff.append(edited_line);
                    buff.append("\n");
                }
                if (line1.contains("</sharding>")) {
                    isMsgComplete = true;
                }
                if (isMsgComplete) {
                    Reporting.report((String)buff.toString());
                    buff = null;
                    hasTagStarted = false;
                    isMsgComplete = false;
                }
                inputBuff.append(line1);
                inputBuff.append("\n");
            }
            retValue = process.waitFor();
            InputStreamReader reader = new InputStreamReader(process.getErrorStream());
            BufferedReader br = new BufferedReader(reader);
            String line = "";
            while ((line = br.readLine()) != null) {
                errorBuff.append(line);
                errorBuff.append("\n");
            }
            if (!StringUtil.isNullOrEmpty((String)errorBuff.toString(), (boolean)true)) {
                logger.info("Patching error execution status :: " + errorBuff.toString());
            }
            if (!StringUtil.isNullOrEmpty((String)inputBuff.toString(), (boolean)true)) {
                logger.info("Patching execution status :: " + inputBuff.toString());
            }
        }
        catch (Throwable t) {
            logger.severe("Execution failed due to : " + t.getMessage());
        }
        ExecutionResult.ExecutionStatus executionStatus = ExecutionResult.ExecutionStatus.SUCCESS;
        if (retValue != 0) {
            executionStatus = ExecutionResult.ExecutionStatus.FAILURE;
        } else if (reportAnalyzeFailure) {
            boolean hasAnalyzeFailed = RemoteAnalysisStatusRetriever.getInstance().retrieveRemoteAnalyzeStatus(patchTarget, credentialManager);
            executionStatus = hasAnalyzeFailed ? ExecutionResult.ExecutionStatus.FAILURE : ExecutionResult.ExecutionStatus.SUCCESS;
        }
        ExecutionResult executionResult = result = new ExecutionResult(new ArrayList<ExecutionResult.CommandExecutionResult>());
        executionResult.getClass();
        ExecutionResult.CommandExecutionResult commandResult = new ExecutionResult.CommandExecutionResult(executionResult, executionStatus, inputBuff.toString(), errorBuff.toString(), cmds.get(2));
        return commandResult;
    }

    public static String getBashCmd() {
        return PatchActionUtil.getCmdPath("bash");
    }

    public static String getSudoCmd() throws OPatchAutoException {
        return PatchActionUtil.getCmdPath("sudo");
    }

    public static String getExpectCmd() {
        return PatchActionUtil.getCmdPath("expect");
    }

    public static String getSuCmd() {
        return PatchActionUtil.getCmdPath("su");
    }

    public static String getCmdPath(String command) {
        String path = "";
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + command).exists()) {
            path = DBCommonPatchingConstants.BIN_PATH + File.separator + command;
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + command).exists()) {
            path = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + command;
        } else {
            int ret = GISystemCall.runTimeExecution("which " + command);
            if (ret == 0) {
                path = command;
            }
        }
        logger.info(command + " path:: " + path);
        return path;
    }

    public static String getExpectFormattedSuCmd() {
        StringBuilder expectCmd = new StringBuilder(PatchActionUtil.getExpectCmd());
        expectCmd.append(" -c \"spawn ");
        expectCmd.append(PatchActionUtil.getSuCmd());
        expectCmd.append(" $0");
        expectCmd.append(" -c \\\"$1\\\"");
        expectCmd.append(";expect Password;send $2\\n");
        expectCmd.append(";interact\"");
        return expectCmd.toString();
    }

    public static String runAsOwner(String command, PatchTarget patchTarget, String owner, CredentialManager credManager) throws OPatchAutoException {
        if (!owner.equals(System.getProperty("user.name"))) {
            Credential credential = credManager.getCredential(patchTarget.getHost().getHost(), null, owner);
            if (null != credential) {
                return PatchActionUtil.runAsOwnerWithoutSudo(command, credential);
            }
            credential = credManager.getCredential(patchTarget.getHost().getHost(), null, System.getProperty("user.name"));
            return PatchActionUtil.runAsOwnerUsingSudo(command, owner, credential);
        }
        return command;
    }

    public static String runAsOwnerWithoutSudo(String command, String username, byte[] password) {
        StringBuilder expectCmd = new StringBuilder(PatchActionUtil.getExpectCmd());
        expectCmd.append(" -c \"spawn su ").append(username);
        expectCmd.append(" -c $0");
        expectCmd.append(";expect Password;send $1");
        expectCmd.append(";interact\"");
        StringBuilder bashCmd = new StringBuilder(PatchActionUtil.getBashCmd());
        bashCmd.append(" -c '").append(expectCmd.toString()).append(" ' ");
        bashCmd.append("\"\\\"").append(command).append("\\\"\"");
        bashCmd.append(" ");
        bashCmd.append("\"\\\"").append(new String(password)).append("\\n").append("\\\"\"");
        return bashCmd.toString();
    }

    public static String runAsOwnerWithoutSudo(String command, Credential credential) throws OPatchAutoException {
        byte[] password = new String(credential.getPassword()).getBytes();
        return PatchActionUtil.runAsOwnerWithoutSudo(command, credential.getUsername(), password);
    }

    public static String runAsOwnerUsingSudo(String command, String owner, Credential credential) throws OPatchAutoException {
        String userName = null;
        String passValue = null;
        userName = credential.getUsername();
        passValue = new String(credential.getPassword());
        if (userName == null || passValue == null) {
            logger.info("No credentials found in wallet");
            Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72048), (Object[])new Object[]{""}));
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72048), (Object[])new Object[]{""}), new Object[0]);
        }
        command = PatchActionUtil.getBashCmd() + " -c " + "'echo " + "'" + passValue + "'" + " | " + PatchActionUtil.getSudoCmd() + " -S -u " + owner + " " + command + "'";
        return command;
    }

    public static String rectifyPath(String path) {
        String rectifiedPath = "";
        logger.info("Actual Path :: " + path);
        if (path != null) {
            rectifiedPath = path.replaceAll("[/\\\\]+", Matcher.quoteReplacement(System.getProperty("file.separator")));
        }
        logger.info("Corrected Path :: " + rectifiedPath);
        return rectifiedPath;
    }

    private static String getProcessedSummary(String line, String parentid) {
        if (!"".equals(parentid) && null != parentid) {
            return line;
        }
        return PatchActionUtil.removeTagFromLines(line);
    }

    private static String removeTagFromLines(String line) {
        if (line.contains("<sharding>")) {
            line = line.replace("<sharding>", "");
        }
        if (line.contains("</sharding>")) {
            line = line.replace("</sharding>", "");
        }
        return line;
    }

    public static RemoteConnectionHandler getHandler(HostImpl hostImpl) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Getting nodelist from remote:  " + hostImpl);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Obtaining remote connection handler for host " + hostImpl);
        }
        RemoteConnectionHandler handler = null;
        try {
            handler = OPatchAutoHelper.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)hostImpl);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Obtained remote connection handler for host " + hostImpl);
            }
        }
        catch (RemoteConnectionException e2) {
            logger.throwing("Detailed Exception while creating remote connection handler : ", e2.getMessage(), e2);
            throw new ProductDriverException("Exception while creating remote connection handler : " + e2.getMessage());
        }
        catch (OPatchAutoException e2) {
            logger.throwing("Detailed OPatchAutoException : ", e2.getMessage(), e2);
            throw new ProductDriverException("OPatchAutoException : " + e2.getMessage());
        }
        return handler;
    }

    public static boolean isOgg(SystemInstance systemInstance) {
        boolean isOgg = false;
        ShardedDatabase shardedDatabase = (ShardedDatabase)systemInstance.getTargetsOfType(ShardedDatabase.class).get(0);
        if (shardedDatabase.getReplicationType().equalsIgnoreCase("Goldengate")) {
            isOgg = true;
        }
        return isOgg;
    }

    public static String getShardingType(SystemInstance systemInstance) {
        ShardedDatabase shardedDatabase = (ShardedDatabase)systemInstance.getTargetsOfType(ShardedDatabase.class).get(0);
        return shardedDatabase.getShardingType();
    }

    public static String getCurrentDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String time = dateFormat.format(date);
        return time;
    }

    public static HostImpl createHostImpl(CredentialManager credentialManager, String hostname, String oracleHomePath, String homeOwner) {
        Credential credential = null;
        try {
            if (credentialManager != null && null == (credential = credentialManager.getCredential(hostname, null, homeOwner))) {
                String message = OPatchAutoHelper.getLocalizedString((String)"PatchActionUtil.home.owner.not.in.wallet", (Object[])new Object[]{homeOwner, oracleHomePath, hostname});
                Reporting.report((String)message);
                throw new ProductDriverException(message);
            }
        }
        catch (OPatchAutoException ex) {
            throw new ProductDriverException("Exception while creating the host impl : " + ex.getMessage());
        }
        return PatchActionUtil.createHostImpl(credential, hostname, oracleHomePath, homeOwner);
    }

    public static HostImpl createHostImpl(Credential credential, String hostname, String oracleHomePath, String homeOwner) {
        HostImpl hostImpl = new HostImpl();
        hostImpl.setHost(hostname);
        hostImpl.setCredential(credential);
        HomeImpl homeImpl = new HomeImpl();
        homeImpl.setLocation(oracleHomePath);
        homeImpl.setHost((Host)hostImpl);
        logger.info("homeImpl : " + homeImpl);
        hostImpl.addHome((Home)homeImpl);
        logger.info("hostImpl : " + hostImpl);
        return hostImpl;
    }

    public static HostImpl createHostImpl(CredentialManager credentialManager, String hostname, String oracleHomePath) {
        return PatchActionUtil.createHostImpl(credentialManager, hostname, oracleHomePath, null);
    }

    public static String replacePwdFrmCmd(String command) {
        String cmd = command;
        if (!StringUtil.isNullOrEmpty((String)command)) {
            if (command.contains("sudo -S -u ")) {
                cmd = "echo '*****' | " + command.substring(command.indexOf("sudo -S -u "));
            } else if (command.contains("expect -c ")) {
                cmd = command.replaceFirst("Password;send.*\\n", "Password;send *****\\\\n");
            }
            if (command.contains("-PASSWORD=")) {
                String[] cmdArr = command.split(" ");
                String wordTobeReplaced = "";
                for (int i = 0; i < cmdArr.length; ++i) {
                    if (!cmdArr[i].startsWith("-PASSWORD=")) continue;
                    wordTobeReplaced = cmdArr[i];
                }
                cmd = command.replace(wordTobeReplaced, "-PASSWORD=***** ");
            }
        }
        return cmd;
    }

    public static List<String> convertStringToList(String text) {
        List<String> convertedList = null;
        if (!StringUtil.isNullOrEmpty((String)text)) {
            convertedList = Arrays.asList(text.split("\\s*,\\s*"));
        }
        return convertedList;
    }
}

