/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.lifecycle.FinalizePhase;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class DeletePatchAction
extends DBCommonPatchAction {
    public DeletePatchAction() {
        super(new Goal[]{FinalizePhase.Goal.finalize});
    }

    public int getOrderingWeight(Goal goal) {
        return 200;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        String zipPatchLocation = System.getProperty(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue());
        return !StringUtil.isNullOrEmpty((String)zipPatchLocation);
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        this.deleteLocalPatch(patchTarget, executionSteps.get(0));
        return new PatchActionResult();
    }

    private boolean deleteLocalPatch(PatchTarget patchTarget, ExecutionStep executionStep) {
        byte[] password = this.getPassword(patchTarget);
        String cmd = executionStep.getCommand().get(0).getValue();
        this._logger.info("Command::" + cmd);
        GISystemCall.ExecReturn ret = GISystemCall.process(cmd, password);
        if (!ret.isOK()) {
            this._logger.warning("Failed to execute command:" + cmd + "Reason::" + ret.getErrorMessage());
        }
        return ret.isOK();
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        return true;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String zipPatchLocation = System.getProperty(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue());
        if (StringUtil.isNullOrEmpty((String)zipPatchLocation)) {
            return executionList;
        }
        ActionType actionType = new ActionType();
        ExecutionStep executionStep = new ExecutionStep(actionType);
        String homeLocation = patchTarget.getHome().getLocation();
        File zipFile = new File(zipPatchLocation);
        String folderName = zipFile.getName().split("\\.")[0];
        File patchLocationParentFile = new File(homeLocation + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP);
        File patchLocationFile = new File(patchLocationParentFile.getAbsolutePath() + File.separator + folderName + File.separator);
        String cmd = "rm -rf " + patchLocationFile.getAbsolutePath();
        executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        executionStep.setHost(host);
        executionList.add(executionStep);
        return executionList;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("DeletePatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("DeletePatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

