/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.EMtargetTypes;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class BinaryPatchCommand {
    public static final byte APPLY_ROLLBACK_SESSION = 0;
    public static final byte ANALYZE_SESSION = 1;
    protected final Logger _logger = Logger.getLogger(BinaryPatchCommand.class.getName());

    public ArrayList<ExecutionStep> generateCommand(PatchTarget patchTarget, Goal goal, PatchSession patchSession, String sessionResultFile) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String operation = patchSession.isRollback() ? OPatchAutoCommand.rollback.name() : OPatchAutoCommand.apply.name();
        String patchParam = null;
        if (patchSession.isRollback() && patchSession.getPatchId() != null) {
            patchParam = patchSession.getProductSupportManager().getOptions().getOption("id").getArg() + " " + patchSession.getPatchId();
        } else {
            patchParam = DBCommandParameters.TEMP_PATCH_LOC.getValue();
            if (this.isPatchBaseDir(patchSession)) {
                patchParam = patchSession.getProductSupportManager().getOptions().getOption("patch.base.directory").getArg() + " " + DBCommandParameters.TEMP_PATCH_LOC.getValue();
            }
        }
        String cmd = PatchPlanUtils.removeFileSeperatorAtEnd(patchTarget.getHome().getLocation()) + File.separator + DBCommonPatchingConstants.OPATCHAUTO_SCRIPT + " " + operation + " " + patchParam + " " + patchSession.getOptions().getOption("home").getArg() + " " + (DBPatchingHelper.isOOPPatchingSession(patchSession.getProductSupportManager().getOptions()) && patchSession.isRollback() ? patchTarget.getHome(true).getLocation() : patchTarget.getHome().getLocation()) + " " + "-target_type" + " " + this.getTargetType(patchTarget) + " " + "-binary";
        String invPtrLoc = null;
        OPatchAutoOption invPtrOpt = patchSession.getProductSupportManager().getOptions().getOption("inventory.pointer.location");
        invPtrLoc = invPtrOpt.getValue();
        if (!StringUtil.isNullOrEmpty((String)invPtrLoc)) {
            cmd = cmd + " " + "-invPtrLoc " + invPtrLoc;
        }
        if (!StringUtil.isNullOrEmpty((String)System.getProperty("java.home")) && !patchTarget.isRemote()) {
            cmd = cmd + " " + "-jre " + System.getProperty("java.home");
        }
        if (DBPatchingHelper.isOOPPatchingSession(patchSession.getProductSupportManager().getOptions())) {
            cmd = cmd + " " + "-ignorejdkvalidation";
        }
        if (goal.equals(InitPhase.Goal.init)) {
            cmd = cmd + " " + "-persistresult" + " " + sessionResultFile + " " + patchSession.getOptions().getOption("analyze").getArg() + " " + "-online";
        } else {
            String analyzeResultFile = this.getSessionFileName(patchTarget, (byte)1, patchTarget.getType());
            cmd = cmd + " " + "-persistresult" + " " + sessionResultFile + " " + "-analyzedresult" + " " + analyzeResultFile;
        }
        if (patchSession.getProductSupportManager().getOptions().getOption("force.conflict").isSwitchEnabled()) {
            cmd = cmd + " " + patchSession.getProductSupportManager().getOptions().getOption("force.conflict").getArg();
        }
        if (patchSession.getProductSupportManager().getOptions().getOption("skip.conflict").isSwitchEnabled()) {
            cmd = cmd + " " + patchSession.getProductSupportManager().getOptions().getOption("skip.conflict").getArg();
        }
        if (patchSession.getProductSupportManager().getOptions().getOption("no.relink").isSwitchEnabled()) {
            cmd = cmd + " " + patchSession.getProductSupportManager().getOptions().getOption("no.relink").getArg();
        }
        String home_loc = patchTarget.getHome().getLocation();
        if (SessionData.getInstance().getAnalyzedPatchList(home_loc) != null && !SessionData.getInstance().getAnalyzedPatchList(home_loc).isEmpty() && patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) && !patchSession.isAnalyze() && DBPatchingHelper.isRHPPatchingSession(patchTarget.getHome().getLocation(), patchSession, SessionData.getInstance().getAnalyzedPatchList(patchTarget.getHome().getLocation()))) {
            cmd = cmd + " " + "-no_patchgen";
        }
        if (!patchSession.isAnalyze() && goal.equals(InitPhase.Goal.init) && !DBPatchingHelper.isOOPPatchingSession(patchSession.getProductSupportManager().getOptions())) {
            cmd = cmd + " " + "-prepare_home";
        }
        this._logger.info("Command generated ::" + cmd);
        ActionType actionType = new ActionType();
        ExecutionStep executionStep = new ExecutionStep(actionType);
        executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        String ohOwner = null;
        ohOwner = !DBPatchingHelper.isStaticConfiguration(patchSession.getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
        User user = new User();
        user.setValue(ohOwner);
        executionStep.setUser(user);
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        executionStep.setHost(host);
        executionList.add(executionStep);
        return executionList;
    }

    public String getSessionFileName(PatchTarget patchTarget, byte sessionType) {
        String sessionFile = this.getSessionFileName(patchTarget, sessionType, patchTarget.getType());
        return sessionFile;
    }

    private String getTargetType(PatchTarget target) {
        String currentType = target.getType();
        String targetType = null;
        if (DBProductTypes.PRODUCT_TYPE_CRS.getValue().equals(currentType)) {
            targetType = EMtargetTypes.cluster.toString();
        } else if (DBProductTypes.PRODUCT_TYPE_RAC.getValue().equals(currentType)) {
            targetType = EMtargetTypes.rac_database.toString();
        } else if (DBProductTypes.PRODUCT_TYPE_SIHA.getValue().equals(currentType)) {
            targetType = EMtargetTypes.has.toString();
        } else if (DBProductTypes.PRODUCT_TYPE_SIDB.getValue().equals(currentType)) {
            targetType = EMtargetTypes.oracle_database.toString();
        }
        return targetType;
    }

    private String getSessionFileName(PatchTarget patchTarget, byte sessionType, String targetInfoToAppend) {
        String sessionResultFile = "sessionresult.ser";
        if (targetInfoToAppend != null) {
            String dbTmp = HelperUtility.detectOraBaseConfig((String)patchTarget.getHome(true).getLocation()) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR;
            sessionResultFile = sessionType == 0 ? dbTmp + "sessionresult_" + patchTarget.getHost().getHost() + "_" + targetInfoToAppend + "_" + OUIDriver.getHomeIndex((String)patchTarget.getHome(true).getLocation()) + ".ser" : dbTmp + "sessionresult_analyze_" + patchTarget.getHost().getHost() + "_" + targetInfoToAppend + "_" + OUIDriver.getHomeIndex((String)patchTarget.getHome(true).getLocation()) + ".ser";
        }
        return sessionResultFile;
    }

    private boolean isPatchBaseDir(PatchSession session) {
        boolean isPatchbaseDir = false;
        if (!StringUtil.isNullOrEmpty((String)session.getPatchBaseDirectory())) {
            isPatchbaseDir = true;
        }
        return isPatchbaseDir;
    }
}

