/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.integration.controller.RemoteContentTransferHandler;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Topology;
import com.oracle.helper.util.HelperUtility;
import java.io.File;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class PatchZipConstructor {
    private static final Logger _log = Logger.getLogger(PatchZipConstructor.class.getName());

    public void createzip(Topology topology, String patchLocation) throws OPatchAutoException {
        for (Host host : topology.getHosts()) {
            if (host.isRemote()) continue;
            String homeForZipCreation = this.identifyHomeForZipCreation(host);
            String ohOwner = OUIDriver.checkFileOwner((File)new File(homeForZipCreation, "oraInst.loc"));
            this.createZip(patchLocation, homeForZipCreation, ohOwner, host.getPassword());
            break;
        }
    }

    private String identifyHomeForZipCreation(Host host) {
        String homeLocation = null;
        Set homes = host.getHomes();
        for (Home home : homes) {
            for (ProductType productType : home.getProductTypes()) {
                if (!productType.getType().equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue()) && !productType.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) continue;
                RemoteContentTransferHandler.getInstance().setSharedLocation(home.isSharedHome());
                homeLocation = home.getLocation();
                break;
            }
            if (StringUtil.isNullOrEmpty(homeLocation)) continue;
            break;
        }
        if (StringUtil.isNullOrEmpty(homeLocation)) {
            Home home = (Home)homes.iterator().next();
            RemoteContentTransferHandler.getInstance().setSharedLocation(home.isSharedHome());
            homeLocation = home.getLocation();
        }
        return homeLocation;
    }

    public void createZip(String patchLocation, String homeForZipCreation, String homeOwner, byte[] password) throws OPatchAutoException {
        String pathForPatchCopy = this.getPathForPatchCopy(patchLocation, homeForZipCreation);
        File zipFilePath = new File(pathForPatchCopy);
        zipFilePath.deleteOnExit();
        System.setProperty("patch.zip.location", pathForPatchCopy);
        if (zipFilePath.exists()) {
            _log.info("Zip file already exists in specified path :: " + pathForPatchCopy);
            return;
        }
        String perlPath = homeForZipCreation + File.separator + "perl" + File.separator + "bin" + File.separator + "perl";
        String scriptPath = homeForZipCreation + File.separator + "OPatch" + File.separator + "auto" + File.separator + "database" + File.separator + "bin" + File.separator + "ZipUnzip.pl zip ";
        String command = perlPath + " " + scriptPath + patchLocation + " " + pathForPatchCopy;
        GISystemCall.ExecReturn ret = GISystemCall.process(command, homeOwner, password);
        GISystemCall.process("chmod +r " + pathForPatchCopy, homeOwner, password);
        if (!ret.isOK()) {
            throw new OPatchAutoException("Failed to create zip from patch..." + ret.getErrorMessage(), new Object[0]);
        }
        _log.info("Zip creation completed.");
    }

    private String getPathForPatchCopy(String patchLocation, String homeForZipCreation) {
        String zipName = new File(patchLocation).getName() + ".zip";
        return HelperUtility.detectOraBaseConfig((String)homeForZipCreation) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + zipName;
    }
}

