/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import oracle.cluster.common.Cluster;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.NotExistsException;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class CrsConfigurationHelper {
    public static final String GET_POLICY_DB = "getPolicyDB";
    private static final Logger _logger = Logger.getLogger(CrsConfigurationHelper.class.getName());

    public static void main(String[] args) {
        String action = null;
        String location = null;
        String crsHome = null;
        List<String> argsList = Arrays.asList(args);
        for (int i = 0; i < argsList.size(); ++i) {
            if (argsList.get(i).equalsIgnoreCase("-ACTION")) {
                action = argsList.get(++i);
                continue;
            }
            if (argsList.get(i).equalsIgnoreCase("-GRID_HOME")) {
                crsHome = argsList.get(++i);
                continue;
            }
            if (!argsList.get(i).equalsIgnoreCase("-OBJECTLOC")) continue;
            location = argsList.get(++i);
        }
        if (!StringUtil.isNullOrEmpty(action, (boolean)true) && action.equals(GET_POLICY_DB) && !StringUtil.isNullOrEmpty(location, (boolean)true) && !StringUtil.isNullOrEmpty(crsHome, (boolean)true)) {
            CrsConfigurationHelper.getPolicyDB(crsHome, location);
        }
    }

    private static void getPolicyDB(String crsHome, String resultLocation) {
        ArrayList<Database> policyDBList = new ArrayList<Database>();
        List<Database> dbList = new ArrayList();
        ArrayList<RACDatabase> racDBList = new ArrayList<RACDatabase>();
        try {
            try {
                System.setProperty("ORACLE_HOME", crsHome);
                DBPatchingHelper.setupEnvironment(System.getProperty("ORACLE_HOME"), System.getProperty("ORACLE_HOME") + File.separator + "oraInst.loc");
                dbList = CrsConfigurationHelper.getSrvmCluster().fetchDatabases();
            }
            catch (Exception e) {
                String message = e.getMessage();
                _logger.info("exception message: " + message);
                if (message.indexOf("PRCD-1027") != -1 || message.indexOf("PRCD-1229") != -1) {
                    ClusterwareInfo info = new ClusterwareInfo();
                    try {
                        List dbuniqnames = info.getHAManagedDatabases(crsHome);
                        DatabaseFactory fact = DatabaseFactory.getInstance();
                        for (String dbname : dbuniqnames) {
                            dbList.add(fact.getDatabase(dbname));
                        }
                    }
                    catch (InstallException e2) {
                        _logger.info("InstallException: " + e.getMessage());
                        throw e2;
                    }
                    catch (NotExistsException e1) {
                        _logger.info("NotExistsException: " + e.getMessage());
                        throw e1;
                    }
                }
                _logger.info("Exception: " + e.getMessage());
                throw e;
            }
            _logger.info("dbList.size: " + dbList.size());
            for (Database db : dbList) {
                _logger.info("db Name: " + db.getUserAssignedName());
                if (!db.isClusterDatabase() || CrsConfigurationHelper.isAdminManagedDB(db)) continue;
                policyDBList.add(db);
            }
            for (Database db : policyDBList) {
                RACDatabase racDB = new RACDatabase();
                racDB.setDatabaseName(db.getUserAssignedName());
                _logger.info("policy db Name: " + racDB.getDatabaseName());
                ArrayList<RACDBInstance> racDBInstList = new ArrayList<RACDBInstance>();
                for (DatabaseInstance inst : db.instances()) {
                    RACDBInstance racDBInst = new RACDBInstance();
                    racDBInst.setInstanceName(inst.getUserAssignedName());
                    _logger.info("inst Name: " + racDBInst.getInstanceName());
                    racDBInst.setHostName(inst.node().getName());
                    _logger.info("host Name: " + racDBInst.getHostName());
                    racDBInstList.add(racDBInst);
                }
                racDB.setDbInstances(racDBInstList);
                racDBList.add(racDB);
            }
            FileUtility.persistDataObj((String)resultLocation, racDBList, (boolean)true);
        }
        catch (Exception e) {
            _logger.info("DatabaseException: " + e.getMessage());
            System.exit(10);
        }
    }

    private static boolean isAdminManagedDB(Database sdb) throws ServerGroupException {
        boolean isAdminManaged = false;
        List serverGrp = sdb.serverGroups();
        if (serverGrp.size() == 1 && !((ServerGroup)serverGrp.get(0)).isServerPool()) {
            isAdminManaged = true;
        }
        _logger.info("isAdminManaged: " + isAdminManaged);
        return isAdminManaged;
    }

    private static Cluster getSrvmCluster() throws ManageableEntityException {
        CommonFactory cf = CommonFactory.getInstance();
        Cluster cls = cf.getCluster();
        return cls;
    }
}

