/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.patch;

import com.oracle.glcm.patch.auto.db.framework.core.patch.CompositePatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchBundle;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.patchmodel.PatchType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.opatch.opatchsdk.SQLPatchStartupMode;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public abstract class PatchPackagesBag {
    private final Logger logger = Logger.getLogger(PatchPackagesBag.class.getName());
    Map<String, Map<String, String>> userPatchLocationMapForPatchID = new HashMap<String, Map<String, String>>();
    private final List<PatchPackage> bag = new ArrayList<PatchPackage>();
    private PatchPackage primaryPatchPackage;

    public void setPrimaryPatchPackage(PatchPackage primaryPatchPackage) {
        this.primaryPatchPackage = primaryPatchPackage;
    }

    public PatchPackage getPrimaryPatchPackage() {
        if (this.primaryPatchPackage == null) {
            this.primaryPatchPackage = this.findPrimaryPatchPackage();
        }
        return this.primaryPatchPackage;
    }

    private PatchPackage findPrimaryPatchPackage() {
        PatchPackage patchPackage = null;
        List<EngineeredSystemPatch> esysPatches = this.getEngineeredSystemPatches();
        if (esysPatches != null && esysPatches.size() > 0) {
            return (PatchPackage)esysPatches.get(0);
        }
        List<PatchBundle> patchBundles = this.getBundlePatches();
        if (patchBundles != null && patchBundles.size() > 0) {
            return (PatchPackage)patchBundles.get(0);
        }
        List<GenericPatch> patches = this.getAllPatches();
        if (patches != null && patches.size() > 0) {
            return (PatchPackage)patches.get(0);
        }
        return patchPackage;
    }

    public List<PatchPackage> getBagContents() {
        return Collections.unmodifiableList(this.bag);
    }

    public final void add(PatchPackage p) throws PatchPackageException {
        try {
            this.logger.fine("Checking to add patch package: " + p + " to the bag.");
            if (this.shouldAddToBag(p)) {
                this.logger.fine("Check passes to add patch package: " + p + " to the bag. Adding...");
                this.bag.add(p);
            } else {
                this.logger.fine("Check did not pass hence not adding patch package: " + p + " to the bag. No exceptions where thrown.");
            }
        }
        catch (PatchPackageException e) {
            this.logger.log(Level.SEVERE, "Check did not pass hence not adding patch package: " + p + " to the bag. Exceptions is being thrown.", e);
            throw e;
        }
    }

    protected abstract boolean shouldAddToBag(PatchPackage var1) throws PatchPackageException;

    public List<GenericPatch> getPatchesForTargetType(String targetType) {
        assert (targetType != null);
        ArrayList<String> targetTypes = new ArrayList<String>();
        targetTypes.add(targetType);
        return this.getPatchesForTargetTypes(targetTypes);
    }

    public List<GenericPatch> getPatchesForTargetTypes(List<String> targetTypes) {
        assert (targetTypes.size() > 0);
        ArrayList<GenericPatch> res = new ArrayList<GenericPatch>();
        for (GenericPatch p : this.getAllPatches()) {
            for (String at : p.getApplicableTargets()) {
                if (!targetTypes.contains(at) || res.contains(p)) continue;
                res.add(p);
            }
        }
        return Collections.unmodifiableList(res);
    }

    public List<GenericPatch> getAllPatches() {
        ArrayList<GenericPatch> res = new ArrayList<GenericPatch>();
        for (PatchPackage pp : this.bag) {
            if (pp instanceof EngineeredSystemPatch) {
                this.logger.log(Level.FINE, "Found patch at location " + pp.getPatchLocation() + " which is instance of EngineeredSystemPatch");
                EngineeredSystemPatch esys = (EngineeredSystemPatch)pp;
                for (GenericPatch p : esys.getSubPatches()) {
                    res.add(p);
                }
                continue;
            }
            if (pp instanceof PatchBundle) {
                this.logger.log(Level.FINE, "Found patch at location " + pp.getPatchLocation() + " which is instance of PatchBundle");
                for (GenericPatch p : ((PatchBundle)pp).getSubPatches()) {
                    res.add(p);
                }
                continue;
            }
            this.logger.log(Level.FINE, "Found patch at location " + pp.getPatchLocation() + " which is instance of GenericSingletonPatch");
            GenericPatch p = (GenericPatch)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public List<GenericPatch> getGenericPatches() {
        ArrayList<GenericPatch> res = new ArrayList<GenericPatch>();
        for (PatchPackage pp : this.bag) {
            if (!(pp instanceof GenericPatch)) continue;
            GenericPatch p = (GenericPatch)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public List<PatchBundle> getBundlePatches() {
        ArrayList<PatchBundle> res = new ArrayList<PatchBundle>();
        for (PatchPackage pp : this.bag) {
            if (!(pp instanceof PatchBundle)) continue;
            PatchBundle p = (PatchBundle)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public List<EngineeredSystemPatch> getEngineeredSystemPatches() {
        ArrayList<EngineeredSystemPatch> res = new ArrayList<EngineeredSystemPatch>();
        for (PatchPackage pp : this.bag) {
            if (!(pp instanceof EngineeredSystemPatch)) continue;
            EngineeredSystemPatch p = (EngineeredSystemPatch)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public String getPatchesListAsString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PatchPackage patchPackage : this.getEngineeredSystemPatches()) {
            if (first) {
                first = false;
                sb.append(patchPackage.getPatchID());
                continue;
            }
            sb.append(", ");
            sb.append(patchPackage.getPatchID());
        }
        for (PatchPackage patchPackage : this.getBundlePatches()) {
            if (first) {
                first = false;
                sb.append(patchPackage.getPatchID());
                continue;
            }
            sb.append(", ");
            sb.append(patchPackage.getPatchID());
        }
        for (PatchPackage patchPackage : this.getGenericPatches()) {
            if (first) {
                first = false;
                sb.append(patchPackage.getPatchID());
                continue;
            }
            sb.append(", ");
            sb.append(patchPackage.getPatchID());
        }
        return sb.toString();
    }

    public void setUserPatchLocationMapForPatchID(Map<String, Map<String, String>> userPatchLocationMapForPatchID) {
        this.userPatchLocationMapForPatchID = userPatchLocationMapForPatchID;
    }

    public Map<String, Map<String, String>> getUserPatchLocationMapForPatchID() {
        return this.userPatchLocationMapForPatchID;
    }

    public void updatePatchPackage(String patchID, OPatchPatchInfo patchInfo, List<String> applicablePatchTarget) throws PatchPackageException {
        PatchPackage patchPackage = null;
        for (PatchPackage selectedPatch : this.bag) {
            if (!selectedPatch.getPatchID().equals(patchID)) continue;
            patchPackage = selectedPatch;
            break;
        }
        if (patchPackage == null) {
            if (patchInfo.isComposite()) {
                CompositePatchValidatorAndGenerator cpvg = new CompositePatchValidatorAndGenerator();
                patchPackage = cpvg.generate(patchID, "", null);
            } else {
                OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
                patchPackage = osvg.generate(patchID, "", null);
            }
            this.bag.add(patchPackage);
        }
        this.fillPatchPackage(patchID, patchInfo, applicablePatchTarget, patchPackage);
        this.primaryPatchPackage = null;
    }

    private void fillPatchPackage(String patchID, OPatchPatchInfo patchInfo, List<String> applicablePatchTarget, PatchPackage patchPackage) throws PatchPackageException {
        GenericPatch patchToUpdate = null;
        patchToUpdate = patchInfo.isComposite() ? this.fillCompositePatch(patchID, patchInfo, applicablePatchTarget, patchPackage) : this.fillSingleTonePatch(patchInfo, applicablePatchTarget, patchPackage);
        if (patchToUpdate != null) {
            patchToUpdate.setRollingPatch(Boolean.valueOf(patchInfo.isRollingPatch()));
            this.updateTargetList(applicablePatchTarget, patchToUpdate);
        }
        this.primaryPatchPackage = this.findPrimaryPatchPackage();
    }

    public GenericPatch fillSingleTonePatch(OPatchPatchInfo patchInfo, List<String> applicablePatchTarget, PatchPackage patchPackage) throws PatchPackageException {
        OPatchSingleton singletonPatch = null;
        if (patchPackage instanceof OPatchSingleton) {
            singletonPatch = (OPatchSingleton)patchPackage;
            singletonPatch.setPatchType(PatchType.SINGLETON);
            if (singletonPatch.getSqlPatch() == null) {
                singletonPatch.setSqlPatch(Boolean.valueOf(patchInfo.isSQLPatch()));
            }
            if (patchInfo.getSqlPatchDatabaseStartupMode() != null && patchInfo.getSqlPatchDatabaseStartupMode().equals(SQLPatchStartupMode.UPGRADE.toString())) {
                singletonPatch.setSqlPatchUpgradeMode(Boolean.valueOf(true));
            } else {
                singletonPatch.setSqlPatchUpgradeMode(Boolean.valueOf(false));
            }
        }
        return singletonPatch;
    }

    public GenericPatch fillCompositePatch(String patchID, OPatchPatchInfo patchInfo, List<String> applicablePatchTarget, PatchPackage patchPackage) throws PatchPackageException {
        CompositePatch compositePatch = null;
        if (patchPackage instanceof OPatchSingleton) {
            this.bag.remove(patchPackage);
            CompositePatchValidatorAndGenerator cpvg = new CompositePatchValidatorAndGenerator();
            compositePatch = cpvg.generate(patchID, "", null);
            this.bag.add((PatchPackage)compositePatch);
            this.logger.finest("Removing and re adding patch from bag");
        } else {
            compositePatch = (CompositePatch)patchPackage;
        }
        if (compositePatch.getSqlPatch() == null) {
            compositePatch.setSqlPatch(Boolean.valueOf(patchInfo.isSQLPatch()));
        }
        ArrayList<GenericSingletonPatch> subPatches = compositePatch.getSubPatches();
        if (patchInfo.getSubPatchList() != null) {
            if (subPatches == null) {
                subPatches = new ArrayList<GenericSingletonPatch>();
            }
            for (String subpatchID : patchInfo.getSubPatchList()) {
                if (this.isListContainsPatch(subpatchID, subPatches)) continue;
                OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
                OPatchSingleton subPatch = osvg.generate(subpatchID, "", null);
                subPatches.add((GenericSingletonPatch)subPatch);
            }
            compositePatch.setSubPatches(subPatches);
        }
        return compositePatch;
    }

    private boolean isListContainsPatch(String patchID, List<GenericSingletonPatch> patches) {
        boolean contains = false;
        for (GenericSingletonPatch patch : patches) {
            if (!patch.getPatchID().equals(patchID)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private void updateTargetList(List<String> applicablePatchTarget, GenericPatch genericPatch) throws PatchPackageException {
        if (genericPatch.getApplicableTargets() == null || genericPatch.getApplicableTargets().isEmpty()) {
            genericPatch.setApplicableTargets(applicablePatchTarget);
        } else {
            List targetsToAdd = genericPatch.getApplicableTargets();
            for (String target : applicablePatchTarget) {
                if (genericPatch.getApplicableTargets().contains(target)) continue;
                targetsToAdd.add(target);
            }
            genericPatch.setApplicableTargets(targetsToAdd);
        }
    }
}

