/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class ConfigCompare
extends SimpleShellCommand {
    public ConfigCompare(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        ArrayList<String> cmds = new ArrayList<String>();
        if (!PatchPlanner.getInstance().isRunningStandalone()) {
            String cmd = "$ORACLE_HOME/OPatch/oplan/oplan configurationCompare <configuration.xml when these steps where generated>";
            cmds.add(cmd);
        } else {
            String oplanLocation = PatchPlanner.getInstance().getOPlanEnv().getOPlanLocation().getAbsolutePath();
            String configXmlPath = PatchPlanner.getInstance().getLogInfo().getConfigXml().getAbsolutePath();
            String setOH = "ORACLE_HOME=" + oh.getPath() + " ";
            String cmd = setOH + oplanLocation + " configurationCompare " + configXmlPath;
            cmds.add(cmd);
        }
        return cmds;
    }

    @Override
    public boolean shouldIncludeStepInExecutionMode(ExecutionMode exeMode) {
        if (ExecutionMode.EM.equals((Object)exeMode) || ExecutionMode.OPATCH.equals((Object)exeMode)) {
            return false;
        }
        return PatchPlanner.getInstance().isRunningStandalone();
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CommandActionType.ConfigCompare.toString())) {
                return null;
            }
            return new ConfigCompare(a);
        }
    }
}

