/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch.impl;

import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.core.patch.CompositePatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.EngineeredSystemPatchGeneratorForZip;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchBundlePatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchPlanZipStreamMapConstructor;
import com.oracle.glcm.patch.auto.db.framework.core.patch.SupportedPatchTools;
import com.oracle.glcm.patch.auto.db.framework.core.patch.TarArchiveInputStreamMapConstructor;
import com.oracle.glcm.patch.auto.db.framework.sdk.intg.PatchPlanIntgFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchBundlexml;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackageFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.patchmodel.Bundle;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchBundle;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.util.BundleValidationException;
import dbmodel.util.BundleXmlException;
import dbmodel.util.BundleXmlHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import oracle.dbsysmodel.patchsdk.PatchFactory;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.PatchValidatorAndGenerator;
import oracle.dbsysmodel.patchsdk.TarArchiveStreamMapConstructor;
import oracle.dbsysmodel.patchsdk.ZipStreamMapConstructor;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class PatchPackageFactoryImpl
extends PatchPackageFactory {
    static Logger logger = Logger.getLogger(PatchPackageFactoryImpl.class.getName());

    @Override
    public PatchPackage getPatchPackageFromDir(File patchDir) throws PatchPackageException {
        PatchPlanner.getInstance().getLogger().setupLogs();
        logger.log(Level.INFO, "Entering getPatchPackageFromDir, getting patch object for the given patch location " + patchDir.getAbsolutePath());
        assert (patchDir != null);
        assert (patchDir.isDirectory());
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        for (PatchValidatorAndGenerator vg : SupportedPatchTools.getSupportedPatchValidatorsAndGenerators()) {
            logger.log(Level.FINE, "Adding PatchValidatorAndGenerator " + vg.getClass().toString());
            pf.addPatchValidatorAndGenerator(vg);
        }
        PatchPackage patch = pf.getInstance(patchDir.getAbsolutePath());
        if (patch == null) {
            throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
        }
        if (patch instanceof GenericPatch) {
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            applicableTarget.add(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().getDefaultApplicableTarget());
            if (patch instanceof OPatchSingleton) {
                applicableTarget.addAll(((GenericPatch)patch).getApplicableTargets());
                OPatchSingletonPatchValidatorAndGenerator.addApplicabilityTargets((OPatchSingleton)patch, applicableTarget);
            }
            if (patch instanceof CompositePatch) {
                CompositePatchValidatorAndGenerator.addApplicabilityTargets((CompositePatch)patch, applicableTarget);
            }
        }
        if (patch instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)patch;
            if (esysPatch.getSubPatches() == null || esysPatch.getSubPatches().isEmpty()) {
                throw new PatchPackageException("The given engineered system patch doesn't contain any supported sub patches.");
            }
            for (GenericPatch subPatch : esysPatch.getSubPatches()) {
                List<Object> oplanRecognizedTargets = new ArrayList();
                oplanRecognizedTargets = PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(subPatch.getApplicableTargets());
                subPatch.setApplicableTargets(oplanRecognizedTargets);
            }
        }
        PatchPlanner.getInstance().getLogger().resetIntegrationLog();
        return patch;
    }

    @Override
    public PatchPackage getPatchPackageFromZip(ZipInputStream patchZip, String patchLocationWhilePatching, String patchId) throws PatchPackageException {
        PatchPlanner.getInstance().getLogger().setupLogs();
        assert (patchZip != null);
        assert (patchLocationWhilePatching != null);
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new CompositePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
        pf.addZipStreamMapConstructor((ZipStreamMapConstructor)new PatchPlanZipStreamMapConstructor());
        PatchPackage instance = pf.getInstance((InputStream)patchZip);
        if (instance instanceof OPatchSingleton) {
            OPatchSingleton singletonPatch = (OPatchSingleton)instance;
            singletonPatch.setPatchLocation(patchLocationWhilePatching);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return singletonPatch;
        }
        if (instance instanceof CompositePatch) {
            CompositePatch compositePatch = (CompositePatch)instance;
            compositePatch.setPatchLocation(patchLocationWhilePatching);
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            PatchPlanIntgFactory oplanIntgFactory = PatchPlanner.getInstance().getOPlanIntgFactory();
            applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
            compositePatch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return compositePatch;
        }
        if (instance instanceof PatchBundle) {
            PatchBundle bundlePatch = (PatchBundle)instance;
            this.setPatchLocationForBundlePatch((Bundle)bundlePatch, patchLocationWhilePatching);
            bundlePatch.setPatchID(patchId);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return bundlePatch;
        }
        if (instance instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)instance;
            EngineeredSystemPatchGeneratorForZip esysPatchGenerator = new EngineeredSystemPatchGeneratorForZip();
            String resourceBundle = esysPatch.getResourceBundle();
            String bundleXmlLocation = esysPatch.getBundleXmlLoc();
            esysPatch = (EngineeredSystemPatch)esysPatchGenerator.generate(esysPatch.getBundleXml(), patchZip, patchLocationWhilePatching, esysPatch.getAutoXmls());
            esysPatch.setResourceBundle(resourceBundle);
            esysPatch.setBundleXmlLoc(bundleXmlLocation);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return esysPatch;
        }
        PatchPlanner.getInstance().getLogger().resetIntegrationLog();
        throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
    }

    @Override
    public PatchPackage getPatchPackageFromTGZ(TarArchiveInputStream patchTarGZ, String patchLocationWhilePatching, String patchId) throws PatchPackageException {
        PatchPlanner.getInstance().getLogger().setupLogs();
        assert (patchTarGZ != null);
        assert (patchLocationWhilePatching != null);
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new CompositePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
        pf.addTarArchiveStreamMapConstructor((TarArchiveStreamMapConstructor)new TarArchiveInputStreamMapConstructor());
        PatchPackage instance = pf.getInstance((InputStream)patchTarGZ);
        if (instance instanceof OPatchSingleton) {
            OPatchSingleton singletonPatch = (OPatchSingleton)instance;
            singletonPatch.setPatchLocation(patchLocationWhilePatching);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return singletonPatch;
        }
        if (instance instanceof CompositePatch) {
            CompositePatch compositePatch = (CompositePatch)instance;
            compositePatch.setPatchLocation(patchLocationWhilePatching);
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            PatchPlanIntgFactory oplanIntgFactory = PatchPlanner.getInstance().getOPlanIntgFactory();
            applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
            compositePatch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return compositePatch;
        }
        if (instance instanceof PatchBundle) {
            PatchBundle bundlePatch = (PatchBundle)instance;
            this.setPatchLocationForBundlePatch((Bundle)bundlePatch, patchLocationWhilePatching);
            bundlePatch.setPatchID(patchId);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return bundlePatch;
        }
        if (instance instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)instance;
            EngineeredSystemPatchGeneratorForZip esysPatchGenerator = new EngineeredSystemPatchGeneratorForZip();
            String resourceBundle = esysPatch.getResourceBundle();
            String bundleXmlLocation = esysPatch.getBundleXmlLoc();
            esysPatch = (EngineeredSystemPatch)esysPatchGenerator.generate(esysPatch.getBundleXml(), (InputStream)patchTarGZ, patchLocationWhilePatching, esysPatch.getAutoXmls());
            esysPatch.setResourceBundle(resourceBundle);
            esysPatch.setBundleXmlLoc(bundleXmlLocation);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return esysPatch;
        }
        PatchPlanner.getInstance().getLogger().resetIntegrationLog();
        throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
    }

    @Override
    @Deprecated
    public PatchPackage getPatchPackageFromZip(ZipInputStream patchZip, String patchLocationWhilePatching) throws PatchPackageException {
        PatchPlanner.getInstance().getLogger().setupLogs();
        assert (patchZip != null);
        assert (patchLocationWhilePatching != null);
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new CompositePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
        pf.addZipStreamMapConstructor((ZipStreamMapConstructor)new PatchPlanZipStreamMapConstructor());
        PatchPackage instance = pf.getInstance((InputStream)patchZip);
        if (instance instanceof OPatchSingleton) {
            OPatchSingleton singletonPatch = (OPatchSingleton)instance;
            singletonPatch.setPatchLocation(patchLocationWhilePatching);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return singletonPatch;
        }
        if (instance instanceof CompositePatch) {
            CompositePatch compositePatch = (CompositePatch)instance;
            compositePatch.setPatchLocation(patchLocationWhilePatching);
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            PatchPlanIntgFactory oplanIntgFactory = PatchPlanner.getInstance().getOPlanIntgFactory();
            applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
            compositePatch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return compositePatch;
        }
        if (instance instanceof PatchBundle) {
            PatchBundle bundlePatch = (PatchBundle)instance;
            this.setPatchLocationForBundlePatch((Bundle)bundlePatch, patchLocationWhilePatching);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return bundlePatch;
        }
        if (instance instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)instance;
            EngineeredSystemPatchGeneratorForZip esysPatchGenerator = new EngineeredSystemPatchGeneratorForZip();
            String resourceBundle = esysPatch.getResourceBundle();
            String bundleXmlLocation = esysPatch.getBundleXmlLoc();
            esysPatch = (EngineeredSystemPatch)esysPatchGenerator.generate(esysPatch.getBundleXml(), patchZip, patchLocationWhilePatching, esysPatch.getAutoXmls());
            esysPatch.setResourceBundle(resourceBundle);
            esysPatch.setBundleXmlLoc(bundleXmlLocation);
            PatchPlanner.getInstance().getLogger().resetIntegrationLog();
            return esysPatch;
        }
        PatchPlanner.getInstance().getLogger().resetIntegrationLog();
        throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
    }

    private void setPatchLocationForBundlePatch(Bundle patch, String patchLocationWhilePatching) {
        String FileSeparator = PatchPlanner.getInstance().getOPlanEnv().isTargetOnWindows() ? "\\" : "/";
        patch.setPatchLocation(patchLocationWhilePatching);
        List subPatches = patch.getSubPatches();
        for (GenericPatch subPatch : subPatches) {
            String subPatchLocation = patchLocationWhilePatching + FileSeparator + subPatch.getPatchLocation();
            subPatch.setPatchLocation(subPatchLocation);
        }
    }

    @Override
    public PatchPackagesBag getPatchPackageBagInstance() {
        return new PatchPackagesBag(){

            @Override
            protected boolean shouldAddToBag(PatchPackage p) {
                return true;
            }
        };
    }

    @Override
    public PatchPackage getPatchPackage(String patchId, String patchLocationWhilePatching, List<String> applicableTargets, boolean isComposite) throws PatchPackageException {
        PatchPlanner.getInstance().getLogger().setupLogs();
        assert (patchId != null);
        assert (patchLocationWhilePatching != null);
        assert (applicableTargets != null);
        assert (applicableTargets.size() > 0);
        OPatchSingleton patch = null;
        if (!isComposite) {
            OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
            patch = osvg.generate(patchId, patchLocationWhilePatching, applicableTargets);
        } else {
            CompositePatchValidatorAndGenerator cpvg = new CompositePatchValidatorAndGenerator();
            patch = cpvg.generate(patchId, patchLocationWhilePatching, applicableTargets);
        }
        PatchPlanner.getInstance().getLogger().resetIntegrationLog();
        return patch;
    }

    @Override
    public PatchPackage getPatchBundleFromBundleStream(InputStream bundleXmlStream, String patchLocationWhilePatching) throws PatchPackageException {
        PatchPackage patch;
        String bundlexmlContent;
        PatchPlanner.getInstance().getLogger().setupLogs();
        try {
            bundlexmlContent = IOUtils.getContent(bundleXmlStream).toString();
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the bundleXml input stream", (Throwable)e);
        }
        try {
            PatchBundlexml pbxml = new PatchBundlexml(bundlexmlContent);
            OPatchBundlePatchValidatorAndGenerator obpvg = new OPatchBundlePatchValidatorAndGenerator();
            patch = obpvg.generate(bundlexmlContent, patchLocationWhilePatching, null);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream.", (Throwable)e);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException((Throwable)e);
        }
        catch (BundleValidationException e) {
            try {
                BundleXmlHelper bhxml = new BundleXmlHelper();
                bhxml.readBundle(bundlexmlContent);
                EngineeredSystemPatchGeneratorForZip espgZip = new EngineeredSystemPatchGeneratorForZip();
                patch = espgZip.generate(bundlexmlContent, patchLocationWhilePatching, null);
                if (((EngineeredSystemPatch)patch).getSubPatches() == null || ((EngineeredSystemPatch)patch).getSubPatches().isEmpty()) {
                    throw new PatchPackageException("The given engineered system patch doesn't contain any supported sub patches.");
                }
            }
            catch (BundleXmlException ex) {
                throw new PatchPackageException((Throwable)ex);
            }
            catch (BundleValidationException ex) {
                throw new PatchPackageException("The patchZip given is neither a Bundle Patch nor an Engineered System Patch", (Throwable)ex);
            }
        }
        if (patch == null) {
            throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported andcould not be validated/generated by any of the PatchValidatorAndGenerator.");
        }
        PatchPlanner.getInstance().getLogger().resetIntegrationLog();
        return patch;
    }
}

