/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.PatchMetadataSessionResult;
import oracle.opatchauto.core.utility.OPatchAutoUtilOptions;
import oracle.opatchauto.core.utility.QueryOperation;

public class PatchMetadaReader {
    private static final String RESULTFILE = "result.ser";
    private static final Logger _log = Logger.getLogger(PatchMetadaReader.class.getName());

    public List<OPatchPatchInfo> getPatchInformation(List<String> patchLocationList) throws OPatchAutoException {
        List<OPatchPatchInfo> patchInfoList = null;
        String oracleHome = OPatchAutoHelper.getOPatchAutoHome();
        String ohOwner = FileUtility.checkFileOwner((File)new File(oracleHome, "oraInst.loc"));
        String currentUser = System.getProperty("user.name");
        patchInfoList = currentUser.equals(ohOwner) ? this.getPatchInfoForOHOwner(patchLocationList, oracleHome) : this.getPatchInfoForRoot(patchLocationList, oracleHome, ohOwner);
        return patchInfoList;
    }

    private List<OPatchPatchInfo> getPatchInfoForOHOwner(List<String> patchLocationList, String oracleHome) throws OPatchAutoException {
        ArrayList<OPatchPatchInfo> patchInfoList = new ArrayList<OPatchPatchInfo>();
        for (String loc : patchLocationList) {
            try {
                OPatchPatch[] opatchPatches = OPatchPatch.getPatchesNoSymbolResolve((String)loc);
                OPatchPatch opatchPatch = opatchPatches[0];
                patchInfoList.add(new OPatchPatchInfo(opatchPatch));
            }
            catch (OPatchException e) {
                throw new OPatchAutoException(e.getLocalizedMessage(), (Throwable)e, new Object[0]);
            }
        }
        return patchInfoList;
    }

    private List<OPatchPatchInfo> getPatchInfoForRoot(List<String> patchLocationList, String oracleHome, String ohOwner) throws OPatchAutoException {
        ArrayList<OPatchPatchInfo> patchInfoList = new ArrayList();
        StringBuffer binaryCommand = this.getBinaryCommand(oracleHome);
        binaryCommand.append(" ");
        binaryCommand.append("query");
        binaryCommand.append(" ");
        binaryCommand.append(QueryOperation.PATCH_METADATA.getValue());
        binaryCommand.append(" ");
        binaryCommand.append(OPatchAutoUtilOptions.PATCH_LOCATION.getValue());
        binaryCommand.append(" ");
        binaryCommand.append(this.getPatchLocationParam(patchLocationList));
        binaryCommand.append(" ");
        binaryCommand.append(OPatchAutoUtilOptions.RESULT.getValue());
        binaryCommand.append(" ");
        String resultFile = this.getResultFile(oracleHome);
        binaryCommand.append(resultFile);
        _log.info("Command for patch metadata::" + binaryCommand.toString());
        Credential cred = null;
        GISystemCall.ExecReturn ret = GISystemCall.process(binaryCommand.toString(), ohOwner, cred);
        _log.fine("Query output::" + ret.getNormalMessage());
        _log.fine("Query err::" + ret.getErrorMessage());
        if (ret.isOK()) {
            _log.info("Reading session result from " + resultFile);
            PatchMetadataSessionResult results = null;
            FileInputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                inputStream = new FileInputStream(resultFile);
                objectInputStream = new ObjectInputStream(inputStream);
                results = new PatchMetadataSessionResult();
                results.readExternal((ObjectInput)objectInputStream);
                patchInfoList = results.getPatchMetaDataList();
                new File(resultFile).delete();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new OPatchAutoException(e.getLocalizedMessage(), new Object[0]);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        throw new OPatchAutoException(ret.getNormalMessage(), new Object[0]);
        return patchInfoList;
    }

    private String getPatchLocationParam(List<String> patchLocList) {
        StringBuffer loc = new StringBuffer();
        int size = patchLocList.size();
        for (int i = 0; i < size; ++i) {
            loc.append(patchLocList.get(i));
            if (i >= size - 1) continue;
            loc.append(",");
        }
        return loc.toString();
    }

    private String getResultFile(String oracleHome) {
        String resultFile = null;
        resultFile = oracleHome + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP + RESULTFILE;
        return resultFile;
    }

    private StringBuffer getBinaryCommand(String oracleHome) {
        StringBuffer binaryCommand = null;
        oracleHome = PatchPlanUtils.removeFileSeperatorAtEnd(oracleHome);
        binaryCommand = new StringBuffer(oracleHome);
        binaryCommand.append(DBCommonPatchingConstants.PERL_RELATIVE_PATH);
        binaryCommand.append(" ");
        binaryCommand.append(oracleHome);
        binaryCommand.append(File.separator + "OPatch" + File.separator + "auto" + File.separator + "database" + File.separator + "bin" + File.separator + "OPatchAutoBinary.pl");
        return binaryCommand;
    }
}

