/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.graphlib;

import com.oracle.glcm.patch.auto.db.framework.core.graphlib.Graph;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class AdjacencyListGraph<T>
implements Graph<T> {
    private Logger logger = Logger.getLogger(AdjacencyListGraph.class.getName());
    Map<T, LinkedList<T>> adjacencyMap;
    Map<T, LinkedList<T>> reverseMap;

    public AdjacencyListGraph(Comparator<T> comp) {
        this.adjacencyMap = new TreeMap<T, LinkedList<T>>(comp);
        this.reverseMap = new HashMap<T, LinkedList<T>>();
    }

    @Override
    public void insertVertex(T key) {
        this.adjacencyMap.put(key, new LinkedList());
        this.reverseMap.put(key, new LinkedList());
    }

    @Override
    public void insertEdge(T origin, T dest) {
        if (origin == null || this.adjacencyMap.get(origin) == null) {
            this.logger.severe("Origin " + origin + " does not exist in the vertex list for creating edge to " + dest);
        }
        if (this.adjacencyMap.get(origin) != null) {
            this.adjacencyMap.get(origin).addLast(dest);
        }
        if (dest == null || this.reverseMap.get(dest) == null) {
            this.logger.severe("Destination " + dest + " does not exist in the vertex list for creating edge from " + origin);
        }
        if (this.reverseMap.get(dest) != null) {
            this.reverseMap.get(dest).addLast(origin);
        }
    }

    @Override
    public Iterable<T> getIncomingVertices(T v) {
        return this.reverseMap.get(v);
    }

    @Override
    public Iterable<T> getOutgoingVertices(T v) {
        return this.adjacencyMap.get(v);
    }

    @Override
    public Iterable<T> getVertices() {
        return this.adjacencyMap.keySet();
    }
}

