/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyDBHome
extends SimpleShellCommand {
    public CopyDBHome(ActionType automationAction) {
        super(automationAction);
    }

    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        List clones = OPlan.getInstance().getMakeCloneHome().getHomeClone(oh);
        for (OracleHome clone : clones) {
            String clonePath = clone.getPath();
            while (clonePath.lastIndexOf("/") == clonePath.length() - 1) {
                clonePath = clonePath.substring(0, clonePath.length() - 1);
            }
            String isBackportEnabledToExcludeScript = OPlan.getInstance().getOPlanEnv().getProperty("EMBackportToExcludeSpecialScripts");
            if (null != isBackportEnabledToExcludeScript && isBackportEnabledToExcludeScript.equalsIgnoreCase("ENABLE")) {
                cmds.add("mkdir -p " + clonePath.substring(0, clonePath.lastIndexOf("/")));
            } else {
                this.changeCloneOwnerAndGroup(cmds, clonePath.substring(0, clonePath.lastIndexOf("/")), oh.getPath());
            }
            cmds.add("cp -pR " + oh.getPath() + " " + clone.getPath());
            cmds.add("rm " + clone.getPath() + "/root.sh");
        }
        return cmds;
    }

    private void changeCloneOwnerAndGroup(List<String> cmds, String clonePath, String ohPath) {
        String scriptFile = File.separator + "tmp" + File.separator + "chgchown";
        cmds.add("echo '#!/bin/bash' > " + scriptFile);
        String newPathList = this.getNewPathList(clonePath);
        cmds.add("echo 'array=(  " + newPathList + " )' >> " + scriptFile);
        cmds.add("echo 'for dir in \"${array[@]}\"' >> " + scriptFile);
        cmds.add("echo 'do' >> " + scriptFile);
        cmds.add("echo ' if [ ! -d $dir ]; then' >> " + scriptFile);
        cmds.add("echo 'echo 'Creating ' $dir' >> " + scriptFile);
        cmds.add("echo 'mkdir $dir' >> " + scriptFile);
        cmds.add("echo $'group=`ls -ld " + ohPath + " | awk \\'{print $4}\\'`'>> " + scriptFile);
        cmds.add("echo 'chgrp $group $dir' >> " + scriptFile);
        cmds.add("echo $'owner=`ls -ld " + ohPath + " | awk \\'{print $3}\\'`'>> " + scriptFile);
        cmds.add("echo 'chown $owner $dir' >> " + scriptFile);
        cmds.add("echo 'fi' >> " + scriptFile);
        cmds.add("echo 'done' >> " + scriptFile);
        cmds.add("chmod +x " + scriptFile);
        cmds.add(scriptFile);
    }

    private String getNewPathList(String clonePath) {
        String pattern = Pattern.quote(File.separator);
        String[] cloneList = clonePath.trim().split(pattern);
        String newList = "";
        String path = "";
        Integer indx = 0;
        while (indx < cloneList.length) {
            if (!cloneList[indx].trim().equals("")) {
                path = path + File.separator + cloneList[indx];
                newList = newList + "  " + path;
            }
            Integer n = indx;
            Integer n2 = indx = Integer.valueOf(indx + 1);
        }
        return newList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<CopyDBHome> {
        public CopyDBHome getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.CopyDBHome.toString())) {
                return null;
            }
            CopyDBHome ch = new CopyDBHome(a);
            return ch;
        }
    }
}

