/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.engine;

import java.util.ArrayList;
import java.util.List;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.db_crs.HAS;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.engine.SequencingEngineUtils;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSSequencingEngineUtils
extends SequencingEngineUtils {
    public boolean includeAction(ActionType action) {
        return this.hasPatchForTargetTypeFromWhilePatching(action);
    }

    private boolean hasPatchForTargetTypeFromWhilePatching(ActionType action) {
        return action.getWhilePatching() != null && !OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(this.getApplicabilityTarget(action.getWhilePatching())).isEmpty();
    }

    private String getApplicabilityTarget(String whilePatching) {
        Class type = SystemModelUtils.getClassForType((String)whilePatching);
        if (HAS.class.isAssignableFrom(type)) {
            return CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString();
        }
        if (RACDatabase.class.isAssignableFrom(type)) {
            return CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString();
        }
        if (SIDatabase.class.isAssignableFrom(type)) {
            return CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString();
        }
        return null;
    }

    public List<Host> sortHosts(List<Host> hostList, PatchingPhase auto_phase) {
        ConfigGraph configGraph = OPlan.getInstance().getConfigGraph();
        return this.sortHosts(hostList, configGraph);
    }

    public List<Host> sortHosts(List<Host> hostList, ConfigGraph configGraph) {
        ArrayList<Host> sortedHostList = new ArrayList<Host>();
        if (hostList != null && !hostList.isEmpty()) {
            ArrayList<Host> hubHostList = new ArrayList<Host>();
            ArrayList<Host> rimHostList = new ArrayList<Host>();
            ArrayList<Host> noRoleHostList = new ArrayList<Host>();
            for (int i = 0; i < hostList.size(); ++i) {
                String nodeRole = this.getNodeRoleByHost(hostList.get(i), configGraph);
                if (nodeRole != null) {
                    if (this.getNodeRoleByHost(hostList.get(i), configGraph).equals("leaf")) {
                        rimHostList.add(hostList.get(i));
                        continue;
                    }
                    hubHostList.add(hostList.get(i));
                    continue;
                }
                noRoleHostList.add(hostList.get(i));
            }
            if (hubHostList != null && !hubHostList.isEmpty()) {
                if (hubHostList.size() > 1) {
                    sortedHostList.addAll(hubHostList.subList(0, hubHostList.size() - 1));
                    sortedHostList.addAll(rimHostList);
                    sortedHostList.addAll(noRoleHostList);
                    sortedHostList.add((Host)hubHostList.get(hubHostList.size() - 1));
                } else {
                    sortedHostList.add((Host)hubHostList.get(0));
                    sortedHostList.addAll(rimHostList);
                    sortedHostList.addAll(noRoleHostList);
                }
            } else if (rimHostList != null && !rimHostList.isEmpty()) {
                sortedHostList.addAll(rimHostList);
                sortedHostList.addAll(noRoleHostList);
            } else {
                sortedHostList.addAll(noRoleHostList);
            }
        }
        return sortedHostList;
    }

    private String getNodeRoleByHost(Host host, ConfigGraph configGraph) {
        List hasList = configGraph.getConnectedTargets((AbstractBaseTarget)host, HAS.class);
        if (hasList == null || hasList.size() <= 0) {
            return null;
        }
        return ((HAS)hasList.get(0)).getNodeRole();
    }
}

