/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnlockOH
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(UnlockOH.class.getName());

    public UnlockOH(ActionType automationAction) {
        super(automationAction);
    }

    public List<String> getShellCommands(CommandContext context) {
        this.logger.log(Level.FINE, "Generating UnlockOH command based on the crs version.");
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        String ohPath = oh.getPath();
        this.logger.log(Level.FINE, "OracleHome path = " + ohPath);
        String version = OPlan.getInstance().getConfigGraph().getRootVertex().getVersion();
        if (version == null) {
            throw new OPlanInternalException("The version of top target in SystemInstance is missing");
        }
        this.logger.log(Level.FINE, "Crs Version is " + version);
        String plPath = null;
        String cmd = null;
        if (version.startsWith("11.2.0.2")) {
            plPath = ohPath + "/OPatch/crs/patch112.pl";
            cmd = "/usr/bin/perl " + plPath + " -unlock" + " -desthome=" + ohPath;
        } else if (version.startsWith("11.2") && !version.startsWith("11.2.0.1")) {
            String destcrsHome = "";
            if ("siha".equals(oh.getHomeType())) {
                plPath = ohPath + "/crs/install/roothas.pl";
                destcrsHome = " -dstcrsHome " + ohPath;
            } else if ("crs".equals(oh.getHomeType())) {
                plPath = ohPath + "/crs/install/rootcrs.pl";
                destcrsHome = " -destcrshome=" + ohPath;
            }
            cmd = "/usr/bin/perl " + plPath + " -unlock" + destcrsHome;
        }
        return Collections.singletonList(cmd);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<UnlockOH> {
        public UnlockOH getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.unlockoh.toString())) {
                return null;
            }
            UnlockOH com = new UnlockOH(a);
            return com;
        }
    }
}

