/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.HAS;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.Command;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootCrsCommand
extends SimpleShellCommand {
    private static final String dstcrshomeOption = "-dstcrshome";
    private static final String nonrollingOption = "-nonrolling";
    Logger logger = Logger.getLogger(RootCrsCommand.class.getName());
    CommandAction automationAction;

    public RootCrsCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    public List<String> getShellCommands(CommandContext context) {
        String ohPath;
        this.logger.log(Level.FINE, "Generating rootcrs command.");
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        String ohOrigPath = ohPath = oh.getPath();
        if (this.automationAction.isActsOnClone() && this.automationAction.getType().equals(CRSCommandActionType.rootcrsswitchback.toString())) {
            OracleHome ohOrig = oh.getOriginalOracleHome();
            ohOrigPath = ohOrig.getPath();
            this.logger.log(Level.FINE, "OracleHome orig path = " + ohOrigPath);
        }
        this.logger.log(Level.FINE, "OracleHome path = " + ohPath);
        String plPath = "";
        String rootPlPath = (String)OPlan.getInstance().getOPlanEnv().getOptionalParam().get(OPlanAccessOptParamKeys.rootCrsPlTempLoc);
        if (rootPlPath == null || rootPlPath.trim().equals("")) {
            rootPlPath = ohPath + "/crs/install";
        }
        this.logger.log(Level.INFO, "rootPlPath: " + rootPlPath);
        if ("siha".equals(oh.getHomeType())) {
            plPath = rootPlPath + "/roothas.pl";
        } else if ("crs".equals(oh.getHomeType())) {
            plPath = rootPlPath + "/rootcrs.pl";
        } else {
            throw new OPlanInternalException("The root crs command can only work on crs or siha oracle home, current oracle home type is: " + oh.getHomeType());
        }
        String perlPath = ohPath + "/perl/bin/perl" + " -I" + ohPath + "/perl/lib" + " -I" + rootPlPath + " ";
        StringBuilder cmd = new StringBuilder(perlPath);
        cmd.append(plPath);
        List automationCommands = this.automationAction.getCommand();
        for (Command c : automationCommands) {
            for (String param : c.getParameter()) {
                if (dstcrshomeOption.equalsIgnoreCase(param)) {
                    cmd.append(" ").append(dstcrshomeOption).append(" ").append(ohOrigPath);
                    continue;
                }
                if ("-rollback".equalsIgnoreCase(param)) {
                    if (!"crs".equals(oh.getHomeType())) continue;
                    cmd.append(" ").append(param.trim());
                    continue;
                }
                cmd.append(" ").append(param.trim());
            }
        }
        String runtimeDeploymentSubType = OPlan.getInstance().getOPlanEnv().getProperty("runtimeDeploymentSubType");
        String autoDeploymentSubType = OPlan.getInstance().getOPlanEnv().getProperty("autoDeploymentSubType");
        if (runtimeDeploymentSubType != null) {
            if (DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(runtimeDeploymentSubType)) {
                cmd.append(" ").append(nonrollingOption);
            }
        } else if (DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(autoDeploymentSubType)) {
            cmd.append(" ").append(nonrollingOption);
        }
        return Collections.singletonList(cmd.toString());
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        List applicableTargets = super.getApplicableTargets(g);
        ArrayList<AbstractBaseTarget> hubApplicableTargets = new ArrayList<AbstractBaseTarget>();
        ArrayList<AbstractBaseTarget> rimApplicableTargets = new ArrayList<AbstractBaseTarget>();
        ArrayList sortedApplicableTargets = new ArrayList();
        ArrayList<AbstractBaseTarget> noRoleApplicableTargets = new ArrayList<AbstractBaseTarget>();
        for (AbstractBaseTarget applicableTarget : applicableTargets) {
            List hostList = g.getConnectedTargets(applicableTarget, Host.class);
            if (hostList == null || hostList.size() <= 0) continue;
            Host host = (Host)hostList.get(0);
            String nodeRole = this.getNodeRoleByHost(g, host);
            if (nodeRole != null) {
                if (nodeRole.equals("leaf")) {
                    rimApplicableTargets.add(applicableTarget);
                    continue;
                }
                hubApplicableTargets.add(applicableTarget);
                continue;
            }
            noRoleApplicableTargets.add(applicableTarget);
        }
        if (hubApplicableTargets != null && !hubApplicableTargets.isEmpty()) {
            if (hubApplicableTargets.size() > 1) {
                sortedApplicableTargets.addAll(hubApplicableTargets.subList(0, hubApplicableTargets.size() - 1));
                sortedApplicableTargets.addAll(rimApplicableTargets);
                sortedApplicableTargets.addAll(noRoleApplicableTargets);
                sortedApplicableTargets.add(hubApplicableTargets.get(hubApplicableTargets.size() - 1));
            } else {
                sortedApplicableTargets.add(hubApplicableTargets.get(0));
                sortedApplicableTargets.addAll(rimApplicableTargets);
                sortedApplicableTargets.addAll(noRoleApplicableTargets);
            }
        } else if (rimApplicableTargets != null && !rimApplicableTargets.isEmpty()) {
            sortedApplicableTargets.addAll(rimApplicableTargets);
            sortedApplicableTargets.addAll(noRoleApplicableTargets);
        } else {
            sortedApplicableTargets.addAll(noRoleApplicableTargets);
        }
        return sortedApplicableTargets;
    }

    private String getNodeRoleByHost(ConfigGraph configGraph, Host host) {
        List hasList = configGraph.getConnectedTargets((AbstractBaseTarget)host, HAS.class);
        if (hasList == null || hasList.size() <= 0) {
            return null;
        }
        return ((HAS)hasList.get(0)).getNodeRole();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<RootCrsCommand> {
        public RootCrsCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.rootcrs.toString()) && !a.getType().equals(CRSCommandActionType.rootcrsswitchback.toString())) {
                return null;
            }
            RootCrsCommand com = new RootCrsCommand((CommandAction)a);
            return com;
        }
    }
}

