/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator;

import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.oplan.OPlan;

public class SqlCommandUtils {
    private static Logger logger = Logger.getLogger(SqlCommandUtils.class.getName());

    public static boolean isPDB(AbstractBaseTarget database) {
        List pdbs;
        if (database instanceof RACDatabase && (pdbs = ((RACDatabase)database).getPDB()) != null && pdbs.size() != 0) {
            logger.fine("Number of pdbs " + pdbs.size());
            return true;
        }
        return false;
    }

    public static String getOracleSIDForActiveInstance(ExecutionStep executionStep, AbstractBaseTarget primaryTarget) {
        if (primaryTarget instanceof RACDBInstance) {
            RACDBInstance instance = (RACDBInstance)primaryTarget;
            return instance.getInstanceName();
        }
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)primaryTarget;
            ExecutionMode exeMode = OPlan.getInstance().getOPlanEnv().getExecutionMode();
            if (ExecutionMode.OPATCH.toString().equalsIgnoreCase(exeMode.toString())) {
                return DBCommandUtils.getOracleSID(executionStep, primaryTarget);
            }
            for (RACDBInstance rdbi : racDB.getDbInstances()) {
                if (rdbi.getIsRunning() != null) {
                    if (!"yes".equals(rdbi.getIsRunning())) continue;
                    executionStep.setHost(rdbi.getHost());
                    return rdbi.getInstanceName();
                }
                return DBCommandUtils.getOracleSID(executionStep, primaryTarget);
            }
            throw new OPlanException("There is no RAC DB Instance running on" + executionStep.getHost().getHostName());
        }
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)primaryTarget;
            return siDB.getInstanceName();
        }
        throw new OPlanException("Can not get OracleSID from " + primaryTarget.getClass().getName());
    }
}

