/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.BasePatch;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.DB;
import model.db_crs.HAS;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import model.patchmodel.Bundle;
import model.patchmodel.CompositePatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import model.patchmodel.PatchPackage;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCommandUtils {
    private static Logger logger = Logger.getLogger(DBCommandUtils.class.getName());
    private static String rollbackType = "rollback";
    private static String switchbackType = "switchback";
    private static String restoreType = "restore";
    private static String sqlPatchRollbackType = "SqlPatchRollback";
    private static String sqlPatchSwitchbackType = "SqlPatchSwitchback";
    private static String sqlPatchRestoreType = "SqlPatchRestore";

    public static boolean isDataGuardConfig(AbstractBaseTarget abt) {
        String dataguardStatus = null;
        DB db = null;
        if (abt instanceof RACDatabase) {
            RACDatabase racDatabase = (RACDatabase)abt;
            dataguardStatus = racDatabase.getDataguardStatus();
            db = racDatabase.getDBsystemInterface();
        } else if (abt instanceof SIDatabase) {
            SIDatabase siDatabase = (SIDatabase)abt;
            dataguardStatus = siDatabase.getDataguardStatus();
            db = siDatabase.getDBsystemInterface();
        }
        if (dataguardStatus != null) {
            List secondarys;
            if (dataguardStatus.toLowerCase().contains("standby")) {
                return true;
            }
            if (dataguardStatus.toLowerCase().equals("primary") && (secondarys = db.getSecondary()) != null && secondarys.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUsingBroker(AbstractBaseTarget abt) {
        DB db = null;
        String dbName = null;
        if (abt instanceof RACDatabase) {
            RACDatabase racDatabase = (RACDatabase)abt;
            db = racDatabase.getDBsystemInterface();
            dbName = racDatabase.getDatabaseName();
        } else if (abt instanceof SIDatabase) {
            SIDatabase siDatabase = (SIDatabase)abt;
            db = siDatabase.getDBsystemInterface();
            dbName = siDatabase.getDatabaseName();
        }
        if (db != null && db.getUsingDataGuardBroker()) {
            logger.info("Database" + dbName + " si using dataguard broker");
            return true;
        }
        return false;
    }

    public static DB getPrimaryDB(AbstractBaseTarget abt) {
        DB primaryDB = null;
        if (abt instanceof RACDatabase) {
            RACDatabase rac = (RACDatabase)abt;
            if (rac.getDataguardStatus() != null && rac.getDataguardStatus().toLowerCase().contains("standby")) {
                primaryDB = rac.getDBsystemInterface().getPrimary();
            } else if (rac.getDataguardStatus() != null && rac.getDataguardStatus().toLowerCase().equals("primary")) {
                primaryDB = rac.getDBsystemInterface();
            }
        } else if (abt instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)abt;
            if (sidb.getDataguardStatus() != null && sidb.getDataguardStatus().toLowerCase().contains("standby")) {
                primaryDB = sidb.getDBsystemInterface().getPrimary();
            } else if (sidb.getDataguardStatus() != null && sidb.getDataguardStatus().toLowerCase().equals("primary")) {
                primaryDB = sidb.getDBsystemInterface();
            }
        }
        return primaryDB;
    }

    public static boolean shouldExecuteSqlCommand(AbstractBaseTarget abt, List<GenericPatch> patches, ActionType actionType) {
        if (restoreType.equals(actionType.getType()) || sqlPatchRestoreType.equals(actionType.getType())) {
            return !DBCommandUtils.isPhysicalStandbyDatabase(abt);
        }
        DB primaryDB = DBCommandUtils.getPrimaryDB(abt);
        if (DBCommandUtils.isPrimaryAndStandbyONSameCluster(abt)) {
            return !DBCommandUtils.isPhysicalStandbyDatabase(abt);
        }
        String dbName = null;
        if (abt instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)abt;
            dbName = racDB.getDatabaseName();
        } else if (abt instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)abt;
            dbName = sidb.getDatabaseName();
        }
        if (primaryDB != null && primaryDB.getSecondary() != null && primaryDB.getSecondary().size() > 0) {
            List secondaryDBs = primaryDB.getSecondary();
            for (DB secondary : secondaryDBs) {
                String secondaryDBName = DBCommandUtils.getDBName(secondary);
                if (DBCommandUtils.isPhysicalStandbyDatabase(abt) && dbName.equals(secondaryDBName) || DBCommandUtils.allPatchesAppliedONHome(patches, DBCommandUtils.getDBOracleHomeObject(secondary))) continue;
                return false;
            }
            if (DBCommandUtils.isPhysicalStandbyDatabase(abt) && !DBCommandUtils.allPatchesAppliedONHome(patches, DBCommandUtils.getDBOracleHomeObject(primaryDB))) {
                return false;
            }
        }
        return true;
    }

    private static boolean allStandbyInSameCluster(DB primaryDB, CRSCluster crs) {
        List racList = crs.getDbRAC();
        List siList = crs.getDbSI();
        if (primaryDB != null && primaryDB.getSecondary() != null && primaryDB.getSecondary().size() > 0) {
            List secondaryDBs = primaryDB.getSecondary();
            for (DB secondary : secondaryDBs) {
                if (secondary.getSI() != null) {
                    SIDatabase si = secondary.getSI();
                    if (siList == null || siList.contains(si)) continue;
                    return false;
                }
                if (secondary.getRAC() == null) continue;
                RACDatabase rac = secondary.getRAC();
                if (racList == null || racList.contains(rac)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isPrimaryAndStandbyONSameCluster(AbstractBaseTarget abt) {
        ConfigGraph configgraph;
        AbstractBaseTarget root;
        DB primaryDB = DBCommandUtils.getPrimaryDB(abt);
        if (primaryDB != null && (root = (configgraph = OPlan.getInstance().getConfigGraph()).getRootVertex()) instanceof CRSCluster) {
            CRSCluster crs = (CRSCluster)root;
            List racList = crs.getDbRAC();
            List siList = crs.getDbSI();
            if (primaryDB.getRAC() != null) {
                RACDatabase primaryRac = primaryDB.getRAC();
                if (racList != null && racList.contains(primaryRac) && DBCommandUtils.allStandbyInSameCluster(primaryDB, crs)) {
                    return true;
                }
            } else if (primaryDB.getSI() != null) {
                SIDatabase primarySi = primaryDB.getSI();
                if (siList != null && siList.contains(primarySi) && DBCommandUtils.allStandbyInSameCluster(primaryDB, crs)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static OracleHome getDBOracleHomeObject(DB db) {
        if (db.getRAC() != null) {
            return ((RACDBInstance)db.getRAC().getDbInstances().get(0)).getRuns_from();
        }
        if (db.getSI() != null) {
            return db.getSI().getRuns_from();
        }
        return null;
    }

    private static String getDBName(DB db) {
        if (db != null) {
            if (db.getRAC() != null) {
                return db.getRAC().getDatabaseName();
            }
            if (db.getSI() != null) {
                return db.getSI().getDatabaseName();
            }
        }
        return null;
    }

    private static boolean allPatchesAppliedONHome(List<GenericPatch> patches, OracleHome oh) {
        List standbyPatches = oh.getPatches();
        boolean isApplied = false;
        for (GenericPatch patch : patches) {
            logger.info("Check if the patch " + patch.getPatchID() + " has been applied on oracle home of standby db " + oh.getName());
            isApplied = false;
            if (standbyPatches != null && standbyPatches.size() > 0) {
                for (BasePatch basePatch : standbyPatches) {
                    if (!basePatch.getPatchID().equals(patch.getPatchID())) continue;
                    logger.info("patch " + patch.getPatchID() + " has been applied on standby database");
                    isApplied = true;
                    break;
                }
                if (isApplied) continue;
                logger.severe("Patch " + patch.getPatchID() + " has not been patched on oracle home " + oh.getPath());
                return false;
            }
            logger.info("No patch in oracle home " + oh.getName());
            return false;
        }
        return true;
    }

    public static boolean isPhysicalStandbyDatabase(AbstractBaseTarget db) {
        String dataGuardStatus = null;
        if (db instanceof RACDatabase) {
            RACDatabase database = (RACDatabase)db;
            dataGuardStatus = database.getDataguardStatus();
        } else if (db instanceof SIDatabase) {
            SIDatabase database = (SIDatabase)db;
            dataGuardStatus = database.getDataguardStatus();
        }
        return dataGuardStatus != null && dataGuardStatus.toLowerCase().contains("physical standby");
    }

    public static boolean isPhysicalStandbyRACDatabase(RACDatabase racDatabase) {
        String dataGuardStatus = racDatabase.getDataguardStatus();
        return dataGuardStatus != null && dataGuardStatus.toLowerCase().contains("physical standby");
    }

    public static OracleHome getPrimaryOHForStandbyRACDatabase(RACDatabase database) {
        RACDatabase primaryRAC;
        List racInsts;
        DB db = database.getDBsystemInterface();
        DB primaryDB = db.getPrimary();
        if (primaryDB.getRAC() != null && (racInsts = (primaryRAC = primaryDB.getRAC()).getDbInstances()) != null && racInsts.size() > 0) {
            return ((RACDBInstance)racInsts.get(0)).getRuns_from();
        }
        if (primaryDB.getSI() != null) {
            SIDatabase primarySI = primaryDB.getSI();
            return primarySI.getRuns_from();
        }
        throw new OPlanInternalException("Can not found the primary host information for standby database " + database.getName());
    }

    public static Host getPrimaryHostForStandbyRACDatabase(RACDatabase database) {
        RACDatabase primaryRAC;
        List racInsts;
        DB db = database.getDBsystemInterface();
        DB primaryDB = db.getPrimary();
        if (primaryDB.getRAC() != null && (racInsts = (primaryRAC = primaryDB.getRAC()).getDbInstances()) != null && racInsts.size() > 0) {
            return ((RACDBInstance)racInsts.get(0)).getHost();
        }
        if (primaryDB.getSI() != null) {
            SIDatabase primarySI = primaryDB.getSI();
            return primarySI.getHost();
        }
        throw new OPlanInternalException("Can not found the primary host information for standby database " + database.getName());
    }

    public static CommandContext resetContext(AbstractBaseTarget db) {
        if (db instanceof RACDatabase) {
            return DBCommandUtils.resetContextByRACDatabase((RACDatabase)db);
        }
        if (db instanceof SIDatabase) {
            return DBCommandUtils.resetContextBySIDatabase((SIDatabase)db);
        }
        return null;
    }

    public static CommandContext resetContextBySIDatabase(SIDatabase sidb) {
        CommandContext context = new CommandContext();
        ArrayList<Host> hosts = new ArrayList<Host>();
        ArrayList<OracleHome> oracleHomeList = new ArrayList<OracleHome>();
        oracleHomeList.add(sidb.getRuns_from());
        hosts.add(sidb.getHost());
        context.setPrimaryTarget((AbstractBaseTarget)sidb);
        context.putTargets(hosts);
        context.putTargets(oracleHomeList);
        return context;
    }

    public static CommandContext resetContextByRACDatabase(RACDatabase racDB) {
        CommandContext context = new CommandContext();
        ArrayList<RACDBInstance> instances = new ArrayList<RACDBInstance>();
        ArrayList<Host> hosts = new ArrayList<Host>();
        ArrayList<OracleHome> oracleHomeList = new ArrayList<OracleHome>();
        for (RACDBInstance inst : racDB.getDbInstances()) {
            instances.add(inst);
            hosts.add(inst.getHost());
            oracleHomeList.add(inst.getRuns_from());
        }
        context.setPrimaryTarget((AbstractBaseTarget)racDB);
        context.putTargets(instances);
        context.putTargets(hosts);
        context.putTargets(oracleHomeList);
        return context;
    }

    public static CommandContext resetContextForStandbyDB(AbstractBaseTarget primaryTarget) {
        DB primaryDB = null;
        CommandContext context = null;
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase rac = (RACDatabase)primaryTarget;
            primaryDB = rac.getDBsystemInterface().getPrimary();
        } else if (primaryTarget instanceof SIDatabase) {
            SIDatabase si = (SIDatabase)primaryTarget;
            primaryDB = si.getDBsystemInterface().getPrimary();
        }
        if (primaryDB != null && primaryDB.getRAC() != null) {
            context = DBCommandUtils.resetContextByRACDatabase(primaryDB.getRAC());
        } else if (primaryDB != null && primaryDB.getSI() != null) {
            context = DBCommandUtils.resetContextBySIDatabase(primaryDB.getSI());
        }
        return context;
    }

    public static boolean isRemoteDB(AbstractBaseTarget target) {
        block3: {
            SystemInstance si;
            block2: {
                si = OPlan.getInstance().getSystemInstance();
                if (!(target instanceof RACDatabase)) break block2;
                RACDatabase rac = (RACDatabase)target;
                List racList = si.getTargetsOfType(RACDatabase.class);
                for (RACDatabase entity : racList) {
                    if (!entity.equals(rac)) continue;
                    return false;
                }
                break block3;
            }
            if (!(target instanceof SIDatabase)) break block3;
            SIDatabase sidb = (SIDatabase)target;
            List sidbList = si.getTargetsOfType(SIDatabase.class);
            for (SIDatabase entity : sidbList) {
                if (!entity.equals(sidb)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getOracleSID(ExecutionStep executionStep, AbstractBaseTarget primaryTarget) {
        if (primaryTarget instanceof RACDBInstance) {
            RACDBInstance instance = (RACDBInstance)primaryTarget;
            return instance.getInstanceName();
        }
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)primaryTarget;
            for (RACDBInstance rdbi : racDB.getDbInstances()) {
                if (!executionStep.getHost().getHostName().equals(rdbi.getHost().getHostName())) continue;
                return rdbi.getInstanceName();
            }
            throw new OPlanException("There is no RAC DB Instance running on" + executionStep.getHost().getHostName());
        }
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)primaryTarget;
            return siDB.getInstanceName();
        }
        throw new OPlanException("Can not get OracleSID from " + primaryTarget.getClass().getName());
    }

    public static String getRACDBVersionForCurrentHome(OracleHome oh) {
        String dbVersion = null;
        RACDatabase racDB = null;
        OracleHome oracleHome = oh;
        if (oh.getOriginalOracleHome() != null) {
            oracleHome = oh.getOriginalOracleHome();
        }
        block0: for (BaseClass bc : OPlan.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof RACDatabase)) continue;
            racDB = (RACDatabase)bc;
            for (RACDBInstance racDBInst : racDB.getDbInstances()) {
                if (!racDBInst.getRuns_from().getPath().equals(oracleHome.getPath())) continue;
                dbVersion = racDB.getVersion();
                continue block0;
            }
        }
        return dbVersion;
    }

    public static boolean isGIPatchingRequested() {
        boolean isGIPatchingRequested = false;
        OracleHome oh = null;
        for (BaseClass bc : OPlan.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof OracleHome)) continue;
            oh = (OracleHome)bc;
            if (!CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString().equals(oh.getHomeType()) || OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString())).isEmpty() || OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(CRSCluster.class) != null || DBCommandUtils.isGIMarkedForSkip()) continue;
            isGIPatchingRequested = true;
            break;
        }
        return isGIPatchingRequested;
    }

    public static boolean isGIMarkedForSkip() {
        boolean isGIMarkedForSkip = false;
        List crss = OPlan.getInstance().getConfigGraph().getSystemInstance().getTargetsOfType(CRSCluster.class);
        CRSCluster crs = (CRSCluster)crss.get(0);
        logger.fine("Checking CRSCluster: " + crs);
        if (crs.getProperty(SkipTargetCookie.class) != null) {
            isGIMarkedForSkip = true;
        }
        return isGIMarkedForSkip;
    }

    public static boolean isSIHAMarkedForSkip() {
        boolean isSIHAMarkedForSkip = false;
        List hasList = OPlan.getInstance().getConfigGraph().getSystemInstance().getTargetsOfType(HAS.class);
        HAS has = (HAS)hasList.get(0);
        logger.fine("Checking HAS: " + has);
        if (has.getProperty(SkipTargetCookie.class) != null) {
            isSIHAMarkedForSkip = true;
        }
        return isSIHAMarkedForSkip;
    }

    public static boolean isGIAndRACPatchingRequested() {
        boolean isGIAndRACPatchingRequested = false;
        boolean isGIRequested = false;
        boolean isRACRequested = false;
        OracleHome oh = null;
        for (BaseClass bc : OPlan.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof OracleHome)) continue;
            oh = (OracleHome)bc;
            if (!isGIRequested && CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString().equals(oh.getHomeType()) && !OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString())).isEmpty() && OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(CRSCluster.class) == null && !DBCommandUtils.isGIMarkedForSkip()) {
                isGIRequested = true;
            }
            if (!(isRACRequested || !CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString().equals(oh.getHomeType()) || OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString())).isEmpty() || OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class) != null && ((List)OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class)).contains(oh.getName()) || oh.getProperty(SkipTargetCookie.class) != null)) {
                isRACRequested = true;
            }
            if (!isGIRequested || !isRACRequested) continue;
            isGIAndRACPatchingRequested = true;
            break;
        }
        return isGIAndRACPatchingRequested;
    }

    private static boolean isUpgradeRequired(List<? extends GenericPatch> subPatches) {
        OPatchSingleton subpatch;
        GenericPatch subPatch;
        boolean isSQLPatchUpgradeMode = false;
        Iterator<? extends GenericPatch> iterator = subPatches.iterator();
        while (!(!iterator.hasNext() || (subPatch = iterator.next()) instanceof OPatchSingleton && (isSQLPatchUpgradeMode = null != (subpatch = (OPatchSingleton)subPatch).getSqlPatchUpgradeMode() ? subpatch.getSqlPatchUpgradeMode() : false))) {
        }
        if (!isSQLPatchUpgradeMode) {
            iterator = subPatches.iterator();
            while (!(!iterator.hasNext() || (subPatch = iterator.next()) instanceof OPatchSingleton && (isSQLPatchUpgradeMode = null != (subpatch = (OPatchSingleton)subPatch).getSqlPatchMigrate() ? subpatch.getSqlPatchMigrate() : false))) {
            }
        }
        logger.info("isSQLPatchUpgradeMode: " + isSQLPatchUpgradeMode);
        return isSQLPatchUpgradeMode;
    }

    public static boolean isSQLPatchUpgradeMode() {
        boolean isSQLPatchUpgradeMode = false;
        PatchPackage patch = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        if (patch instanceof Bundle) {
            List subPatches = ((Bundle)patch).getSubPatches();
            isSQLPatchUpgradeMode = DBCommandUtils.isUpgradeRequired(subPatches);
        } else if (patch instanceof OPatchSingleton) {
            if (null != ((OPatchSingleton)patch).getSqlPatchUpgradeMode()) {
                isSQLPatchUpgradeMode = ((OPatchSingleton)patch).getSqlPatchUpgradeMode();
            }
            if (!isSQLPatchUpgradeMode) {
                isSQLPatchUpgradeMode = null != ((OPatchSingleton)patch).getSqlPatchMigrate() ? ((OPatchSingleton)patch).getSqlPatchMigrate() : false;
            }
        } else if (patch instanceof CompositePatch) {
            List subPatches = ((CompositePatch)patch).getSubPatches();
            isSQLPatchUpgradeMode = DBCommandUtils.isUpgradeRequired(subPatches);
        }
        return isSQLPatchUpgradeMode;
    }
}

